#include "mbed.h"
#include <time.h>
#include <stdlib.h>
#include <RF22.h>
#include <RF22ReliableDatagram.h>
//#include "SDFileSystem.h"

// Sample programm for ReliableDatagramm Sending
// Uses address 1 and sends to RF22 with address 2
// See notebook http://mbed.org/users/charly/notebook/rfm22/ for connecting RFM22 to mbed

int check_sw3();
int init();
void affichage(uint8_t val);
void send_loop();

Serial pc(USBTX, USBRX);
 
RF22ReliableDatagram rf22(0,D10,D11,D12,D13,D2);

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

DigitalIn sw3(SW3);
 
float frequency = 869.85;           // frequency 
 
const uint8_t sender_adress = 1;        // address of sender
const uint8_t receiver_adress = 2;       // address of receiver
 
int counter = 0;                      // message counter

int check_sw3(void)
{
    if (sw3 == 0) 
    {
        printf("SW3 button pressed. \n");
        return 1;
    } else return 0;
}

int init()
{
    // initialize the device
    if (!rf22.init())
    {
        pc.printf("RF22 init failed\n\r");
        return 1;
    }
    // set to 19.2
    if (!rf22.setModemConfig(RF22::OOK_Rb9_6Bw335))
    {
        pc.printf("setModemConfig failed");
        return 1;
    }
    if (!rf22.setFrequency(frequency))
    {
        pc.printf("setFrequency failed");
        return 1;
    }
    rf22.setTxPower(RF22_TXPOW_8DBM);
        
    rf22.setModeTx(); 
    
    pc.printf("I am sending with address %i to adress %i ...\n\r",sender_adress,receiver_adress  );
    rf22.setThisAddress(sender_adress);     // sender-adress
    
    return 0;

}
    

void affichage(uint8_t val)
{
    uint8_t mask;
    mask = 0x80;
    int i;
    
    for(i=0 ; i<8 ; i++)
    {
        if((val & mask) == 0) pc.printf("0");
        else pc.printf("1");
        mask = mask >> 1;
    }
}
 
// send messages
void send_loop(){
    
    led_green = 0;
    led_red = 1;
    
    uint8_t data[32] = "";
    
    uint8_t tab1;
        
    int value1;
    
    srand(time(NULL));
    value1 = (rand() % 31);
         
    tab1 = (uint8_t)value1;
        
    pc.printf("value1 : %d, binaire : ",value1);
    affichage(tab1);
    pc.printf("\n\r");
    
    while (counter != 1000) {
        counter++;
        sprintf((char*)data,"%d",counter);
        
            pc.printf("\n\n\rStart sending ...");
            if (rf22.sendtoWait(data, sizeof(data), receiver_adress))
            {
                pc.printf("\n\rSend to %i ACK: >>%s<<", receiver_adress,(char*)data);
            } 
            else 
            {
                pc.printf("\n\rSend to %i NOT ACK: >>%s<<", receiver_adress,(char*)data);
            }
    }
    
    led_red = 0; // on
    led_green = 1; // off
}

int main() {
    
    int b = 2;
    
    pc.baud(9600); 
    
    pc.printf("\n\rConnected to mbed\n\r");
 
    pc.printf ("RF22-Test-Reliable-Send V1.0\n\r");
    
    // initialisation communication
    if(init() == 0) b = 1;
    
    if (b == 1)
    {
        led_green = 1;
        led_red = 0;
        while(1) {
            if(check_sw3() == 1) {
                send_loop();
            }
            wait(1);
        }
    } 
    else
    {
        pc.printf("Probleme lors de l'initialisation");
    }
    
  return 0;
   
}
 
