#include "mbed.h"
#include "rtos.h"
#include <time.h>
#include <stdlib.h>
#include <RF22.h>
#include <RF22ReliableDatagram.h>

// Sample programm for ReliableDatagramm Receiving
// Uses address 2 and receives from Sender
// See notebook http://mbed.org/users/charly/notebook/rfm22/ for connecting RFM22 to mbed

int init();
void affichage(uint8_t val);
void receive_loop();

Serial pc(USBTX, USBRX);

int count =0;

RF22ReliableDatagram rf22(0,D10,D11,D12,D13,D2);
 
float frequency = 869.85;           // frequency --> ((selectable for each channel between 868.15, 868.3, 868.45, 868.825, 868.95, 869.075, 869.85 MHz) OOK -- ancienne valeur : 869.50
 
const uint8_t sender_adress = 1;    // address of sender
const uint8_t receiver_adress = 2;  // address of receiver

int init()
{
    // initialize the device
    if (!rf22.init())
    {
        pc.printf("RF22 init failed\n\r");
        return 1;
    }
    // set to 19.2
    if (!rf22.setModemConfig(RF22::OOK_Rb9_6Bw335))
    {
        pc.printf("setModemConfig failed");
        return 1;
    }
    if (!rf22.setFrequency(frequency))
    {
        pc.printf("setFrequency failed");
        return 1;
    }
    rf22.setTxPower(RF22_TXPOW_8DBM);
        
    rf22.setModeRx(); 
    
    pc.printf("I am sending with address %i to adress %i ...\n\r",sender_adress,receiver_adress  );
    rf22.setThisAddress(sender_adress);     // sender-adress
    
    return 0;
}


void affichage(uint8_t val)
{
    uint8_t mask;
    mask = 0x80;
    int i;
    
    for(i=0 ; i<8 ; i++)
    {
        if((val & mask) == 0) pc.printf("0");
        else pc.printf("1");
        mask = mask >> 1;
    }
}


void receive_loop() {
    uint8_t buf[RF22_MAX_MESSAGE_LEN];
    uint8_t len;
    len = sizeof(buf);
    
    while (1) {    
        if (rf22.recvfromAck(buf, &len))
        {
            pc.printf("\n\rgot message: >");
            affichage((uint8_t)buf);
            pc.printf("< : %d", buf);
        }
    }
}

int main() {

    int b = 2;
    pc.printf ("RECEIVER");
 
    pc.baud(9600); // ancienne valeur : 115200
    pc.printf("\n\rConnected to mbed\n\r");
 
    pc.printf ("RF22-Test-Reliable-Receive V1.0\n\r");
 
    if(init() == 0 ) b = 1;
    
    if(b == 1)
    { 
        receive_loop();     // start receiving
    }
    
    return 0;
}
 
 