#include "mbed.h"
#include "rtos.h"
#include <time.h>
#include <stdlib.h>
#include <RF22.h>
#include <RF22ReliableDatagram.h>
#include "SDFileSystem.h"
#include "INA219.hpp"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include <string>

// Sample programm for ReliableDatagramm Sending
// Uses address 1 and sends to RF22 with address 2
// See notebook http://mbed.org/users/charly/notebook/rfm22/ for connecting RFM22 to mbed
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
FILE *fp1;
FILE *fp2;
FILE *fp3;

Serial pc(USBTX, USBRX);

// Get this to work with the INA219 Breakout from Adafruit
INA219 ina219(D14, D15, 0x40, 400000, RES_10BITS);

//RF22ReliableDatagram (uint8_t thisAddress, PinName slaveSelectPin, PinName mosi, PinName miso, PinName sclk, PinName interrupt)
RF22ReliableDatagram rf22(0,D10,D11,D12,D13,D2);

float frequency = 869.85;           // frequency

const uint8_t sender_adress = 1;        // address of sender
const uint8_t receiver_adress = 2;       // address of receiver

int counter = 0;                      // message counter


DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalIn sw3(SW3);
EthernetInterface   eth;
TCPSocketConnection server;
NTPClient           ntp;
time_t              rtcTime;
char                tStr[32];

int check_sw3(void)
{
    if (sw3 == 0) {
        printf("SW3 button pressed. \n");
        return 1;
    } else return 0;
}


// send messages forever
void send_loop()
{
    led_green = 0;
    led_red = 1;
    counter = 0;
    uint8_t data[32] = "";

    while (counter != 1000) {
        counter++;
        fp1 = fopen("/sd/envoie.txt","a");
        sprintf((char*)data,"%d",counter);
        // Display time before sending
        pc.printf("\n\rStart sending ... 1");
        if (rf22.sendtoWait(data, sizeof(data), receiver_adress)) {
            // Display time after sending
            /*rtcTime = time(NULL); //read the time
            strftime(tStr, 32, "%X\n", localtime(&rtcTime));
            printf("\n\rTime as a custom formatted string AFTER sending= %s", tStr);*/
            //wait(1);
            pc.printf("\n\rSend to %i ACK: >>%s<<", receiver_adress,(char*)data);
            fprintf(fp1,"%d\n",counter);

        } else {
            pc.printf("\n\rSend to %i NOT ACK: >>%s<<", receiver_adress,(char*)data);
            // Display time after sending
            /*rtcTime = time(NULL); //read the time
            strftime(tStr, 32, "%X\n", localtime(&rtcTime));
            printf("\n\rTime as a custom formatted string AFTER sending= %s", tStr);*/
            fprintf(fp1,"%d\n",counter);
            //wait(1);
        }
        fclose(fp1);
    }

    led_red = 0; // on
    led_green = 1; // off

}


void Measure(void const *args)
{
    //printf("hello this is the current and voltage of our circuit\r\n\n");
    float volt;
    float current_ma;
    fp2 = fopen("/sd/voltage.txt","a");
    fp3 = fopen("/sd/courant.txt","a");

    fprintf(fp2,"\n");
    fprintf(fp3,"\n");

    fclose(fp2);
    fclose(fp3);

    if((fp1 != NULL) && (fp2 != NULL)) {

        while(1) {
            volt= ina219.read_bus_voltage();
            current_ma = ina219.read_current_mA();

            fp2 = fopen("/sd/voltage.txt","a");
            fp3 = fopen("/sd/courant.txt","a");

            fprintf(fp2,"%f\n", volt);
            //printf("\r volt :%f\n", volt);
            fprintf(fp3,"%f\n", current_ma);
            //printf("\r courant : %f\n\n", current_ma);

            fclose(fp2);
            fclose(fp3);

            wait(5);
        }
    }
}

int Init_Comm ()
{
    // Setting comm
    pc.baud(9600);
    pc.printf("\n\rConnected to mbed\n\r");

    pc.printf ("RF22-Test-Reliable-Send V1.0\n\r");

    // initialize the device
    if (!rf22.init()) {
        pc.printf("RF22 init failed\n\r");
        return 1;
    }

    // set to 19.2
    if (!rf22.setModemConfig(RF22::OOK_Rb9_6Bw335)) { // 9.6 kbs
        pc.printf("setModemConfig failed\n\r");
        return 1;
    }

    if (!rf22.setFrequency(frequency)) {
        pc.printf("setFrequency failed\n\r");
        return 1;
    }

    rf22.setTxPower(RF22_TXPOW_8DBM);
    rf22.setModeTx();
    return 0;

}

int Init_Eth ()
{
    printf("Setting up ethernet interface...\r\n");
    if (eth.init() == 0 ) { //Use DHCP
        printf("Ethernet setup OK\r\n");
    } else {
        printf("Error: cannot set ethernet interface\r\n");
        return 1;
    }

    printf("Trying to connect...\r\n");
    wait(0.5);
    if ( eth.connect(30000) == 0 ) {
        printf("IP Address is %s\r\n", eth.getIPAddress());
    } else {
        printf("Error: cannot set ethernet interface\r\n");
        return 1;
    }

    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.fr.pool.ntp.org") == 0) { //set RTC time
        printf("Set time successfully\r\n");
        wait(1);
        rtcTime = time(NULL); //read the time
        printf("Current time is: %s\r\n", ctime(&rtcTime));
    } else {
        printf("Error: Cannot set time\r\n");
    }

    printf("Disconnecting...\r\n");
    eth.disconnect();
    wait(1);
    printf("Ethernet disconnected\r\n");

    return 0;
}


int main()
{
    int b,c = 0;

    if(Init_Comm()== 0) b = 1;
    //if(Init_Eth()== 0) c = 1;

    if (b == 1) {
        led_green = 1;
        led_red = 0;
        pc.printf("I am sending with address %i to adress %i ...\n\r",sender_adress,receiver_adress  );
        rf22.setThisAddress(sender_adress);     // sender-adress
        //Thread t1(Measure);
        //Thread t2(send_loop);
        while(1) {
            if(check_sw3() == 1) {
                send_loop();
            }
            wait(1);
        }

    } else {
        pc.printf("Probleme lors de l'initialisation");
    }

    return 0;

}

