#include "HeptaXbee.h"
#include "mbed.h"
#include  <stdarg.h>

HeptaXbee::HeptaXbee(PinName tx, PinName rx) : xbee(tx,rx)
{
    rcmd = 0;
    cmdflag = 0;
}
void HeptaXbee::baud(int rate)
{
    xbee.baud(rate);
}
void HeptaXbee::xbee_recieve(int *xrcmd, int *xcmdflag) {
    xbee.attach(this,&HeptaXbee::commandget,Serial::RxIrq);
    //xbee.printf("ssXbeedata= %d,%d",HeptaXbee::rcmd,HeptaXbee::cmdflag);
    *xrcmd = HeptaXbee::rcmd;
    *xcmdflag = HeptaXbee::cmdflag;
}

void HeptaXbee::initialize(){
    HeptaXbee::rcmd = 0;
    HeptaXbee::cmdflag = 0;
}

void HeptaXbee::commandget(){
    HeptaXbee::rcmd=xbee.getc();
    HeptaXbee::cmdflag = 1;
    //xbee.printf("Xbeedata= %d,%d",rcmd,cmdflag);
}
void HeptaXbee::putc(char data)
{
    xbee.putc(data);
}
void HeptaXbee::xbee_transmit(char* output_data,size_t output_n,
                        char data1[],char data2[],char data3[],char data4[],char data5[],char data6[],char data7[],char data8[],char data9[],
                            int n1,int n2,int n3,int n4,int n5,int n6,int n7,int n8,int n9)
{
    int N=0,i=0,ii,jj=0;
    for(i = 0; i <= n1-1; i++){
        output_data[N+i] = data1[i];
    }
    N=i;
    for(i = 0; i <= n2-1; i++){
        output_data[N+i] = data2[i];
    }
    N=N+i;
    for(i = 0; i <= n3-1; i++){
        output_data[N+i] = data3[i];
    }
    N=N+i;
    for(i = 0; i <= n4-1; i++){
    output_data[N+i] = data4[i];
    }
    N=N+i;
    for(i = 0; i <= n5-1; i++){
    output_data[N+i] = data5[i];
    }
    N=N+i;
    for(i = 0; i <= n6-1; i++){
    output_data[N+i] = data6[i];
    }
    N=N+i;
    for(i = 0; i <= n7-1; i++){
    output_data[N+i] = data7[i];
    }
    N=N+i;
    for(i = 0; i <= n8-1; i++){
    output_data[N+i] = data8[i];
    }
    N=N+i;
    for(i = 0; i <= n9-1; i++){
    output_data[N+i] = data9[i];
    }
    for(ii=0;ii<output_n;ii++){
        xbee.putc(output_data[ii]);  
        jj++;
        if(jj==2)
        {
            xbee.putc(0x20);
            jj=0;
        }      
    }
    xbee.putc(0x0a);   
}
void HeptaXbee::puts( char *s ) {
        while ( char c    = *s++ )
            xbee.putc( c );
}
void HeptaXbee::printf( char *format, ... ) {
        char        s[ 32 ];
        va_list        args;

        va_start( args, format );
        vsnprintf( s, 32, format, args );
        va_end( args );

        xbee.puts( s );
}