#include "HeptaVoice.h"

HeptaVoice::HeptaVoice(PinName sda, PinName scl, int addr):_i2c(sda, scl),_addr(addr)
{
    _addr = addr;
    _poll_wait.reset();
    _poll_wait.start();
}

bool HeptaVoice::IsActive(int timeout_ms)
{
    wait_ms(AQTK_STARTUP_WAIT_MS);
    Timer t;
    t.reset();
    t.start();
    while(t.read_ms() < timeout_ms) {
        _poll_wait.reset();
        if (_i2c.write(_addr, NULL, 0) == 0) {
            return true;
        }
        wait_ms(AQTK_POLL_WAIT_MS);
    }
    return false;
}
    
void HeptaVoice::Synthe(const char* msg)
{
    while(IsBusy()) {
        ;
    }
    Write(msg);
    Write("\r");
}

void HeptaVoice::Write(const char *msg)
{
    _i2c.write(_addr, msg, strlen(msg));    
    _poll_wait.reset();
}

bool HeptaVoice::IsBusy()
{
    if (AQTK_POLL_WAIT_MS > _poll_wait.read_ms()) {
        return true;
    } 
    _poll_wait.reset();
    char c = 0x00;
    if (_i2c.read(_addr, &c, 1) != 0) {
        return false;
    }
    return c == '*' || c == 0xff;
}
