#ifndef MBED_HEPTAGPS_H
#define MBED_HEPTAGPS_H
#include "mbed.h"

class HeptaGPS{
public:
    Serial gps;
    HeptaGPS(
        PinName tx,
        PinName rx 
    );
    void baud(int rate);
    char getc();
    int  readable();
    void flushSerialBuffer(void);
    void gga_sensing(float *time, float *latitude, char *ns, float *longitude, char *ew, int *quality, int *stnum, float *hacu, float *altitude, char *aunit, int *gps_check);
    void lat_log_sensing_u16(char *lat, char *log, int *dsize);
private:
    char msg[256],msgd[256];
    int i,ite,rlock,stn;
    char c;
    char gps_data[7][1000];
    char ns,ew,statas;
    float time,hokui,tokei,vel;
    float g_hokui,g_tokei;
    float d_hokui,m_hokui,d_tokei,m_tokei;
    int h_time,m_time,s_time;
};
#endif