#include "mbed.h"
#include "HeptaBattery.h"
#include "SDFileSystem.h"
#include "HeptaAccel.h"
#include "HeptaGyro.h"
#include "HeptaGPS.h"
#include "HeptaLcd.h"
#include "HeptaVoice.h"
#include "HeptaCamera.h"
#include "HeptaXbee.h"

HeptaBattery battery(p16,p29,p26);//(battery voltage,power cotrol transister,3.3V regulater enable)
SDFileSystem sd(p11, p12, p13, p15, "sd");//(cmd,dat0,clk,dat3)
HeptaAccel accel(p28,p27,0x38);//(sda,scl,I2C address)
HeptaGyro gyro(p28,p27,0xD4);//(sda,scl,I2C address)
HeptaGPS gps(p13,p14);//tx,rx(Din,Data_Out)
HeptaLcd lcd(p28,p27,0x7C);//(sda,scl,I2C address)
HeptaVoice talk(p28, p27,0x5C); //(sda,scl,I2C address)

HeptaCamera camera(
    p28,p27,       // SDA,SCL(I2C / SCCB)
    p21,p22,p23,   // VSYNC,HREF,WEN(FIFO)
    p5,p6,p7,p8,p30,p17,p25,p18, // D7-D0
    p20,p24,p19) ; // RRST,OE,RCK

HeptaXbee xbee(p9, p10);//tx,rx(Din,Dout)

//----Serial----//
Serial pc(USBTX,USBRX);

//----LED----//
DigitalOut led1(LED1);

int main()
{
    led1 = 1;
    wait(0.5);
    led1 = 0;
    wait(0.5);
}