#include "mbed.h"
#include "Hepta.h"

HeptaGPS gps(p13,p14);//tx,rx(Din,Data_Out)
HeptaBattery battery(p16,p29,p26);//(battery voltage,power cotrol transister,3.3V regulater enable)
SDFileSystem sd(p11, p12, p13, p15, "sd");//(cmd,dat0,clk,dat3)
HeptaGyro gyro(p28,p27,0xD4);//(sda,scl,I2C address)
HeptaAccel accel(p28,p27,0x38);//(sda,scl,I2C address)
TextLCD_SB1602E lcd(p28,p27,0x7C);//(sda,scl,I2C address)
ATP3011 talk(p28, p27,0x5C); //(sda,scl,I2C address)
HeptaXbee xbee(p9, p10);//tx,rx(Din,Dout)

HeptaCamera camera(
    p28,p27,       // SDA,SCL(I2C / SCCB)
    p21,p22,p23,   // VSYNC,HREF,WEN(FIFO)
    p5,p6,p7,p8,p30,p17,p25,p18, // D7-D0
    p20,p24,p19) ; // RRST,OE,RCK

//----SERIAL----//

//----LED----//
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4); 

int main() {
        char mode;
    pc.baud(9600);
    //pc.baud(921600);
    while(1) {
        pc.printf("Hello world. This is DEMO mode\r\n");
        pc.printf("Please select mode.\r\n");
        pc.printf("1:LED Mode\r\n");
        pc.printf("2:LED Count Mode\r\n");
        pc.printf("3:Electrical Vlotage Detection Mode\r\n");
        pc.printf("4:Battery Charge Mode\n\r");
        pc.printf("5:Battery Fast Charge Mode\r\n");
        pc.printf("6:SD Card Check Mode\n\r");
        pc.printf("7:Storing Battery Voltage to SD Card Mode\r\n");
        pc.printf("8:Gyro Sensor Mode\r\n");
        pc.printf("9:Accel Sensor Mode\r\n");
        pc.printf("a:GPS Sensor Mode\r\n");
        pc.printf("b:Camera Mode\r\n");
        pc.printf("c:LCD Mode\r\n");
        pc.printf("d:Voice Mode\r\n");
        pc.printf("e:Xbee Mode\r\n");
        pc.printf("f:All Data Downlink to Pc Mode\r\n");
        pc.printf("g:All Data Downlink to Pc by Xbee Mode\r\n");
        pc.printf("h:High speed sensing mode for gyro & accel Mode\r\n");
        pc.printf("i:High speed sensing mode and caluclate to deg\r\n");
        mode = pc.putc(pc.getc());
        pc.printf("\n\r");
        if(mode=='0'){
            pc.printf("0:Under construction!!!\n\r");
        }else if(mode=='1'){
        pc.printf("1:LED Mode\n\r");
            while(1) {
                led1 = 1;
                wait(0.2);
                led2 = 0;
                wait(0.2);
            }
        }else if(mode=='2'){
            pc.printf("2:LED Count Mode\n\r");
            int k=1; //初期化
            while(1) {
                if(k>0x10)k=1;  //ｋが0b00010000になったら0b00000001にする
                led1 = k & 0x01;
                led2 = k & 0x02;
                led3 = k & 0x04;
                led4 = k & 0x08;
                k=k<<1; //kの中を左に1つ移動
                wait(0.1); //0.1秒待つ
            }
        }else if(mode=='3'){
            pc.printf("3:Electrical Vlotage Detection Mode\n\r");
            int i,dsize;
            float bt;
            char abt[4];
            pc.printf("Hellow\r\n");
            while(1){
                battery.vol(&bt);
                battery.vol_u16(abt,&dsize);
                pc.printf("Vol = %f\r\n",bt);
                pc.printf("Vol_u16 = ");
                for(i=1;i<dsize;i++){
                    pc.putc(abt[i]);
                }
                pc.printf("\r\n");
                wait(1.0);
            }
        }else if (mode=='4'){
            pc.printf("4:Battery Charge Mode\n\r");
            float bt;
            int save_flag;
            while(1) {
                battery.charge(&save_flag);
                battery.vol(&bt);
                pc.printf("Vol = %f\r\n",bt);
                pc.printf("save = %d\r\n",save_flag);
                if(save_flag == 0){
                    pc.printf("Vol = %f\r\n",bt);
                }
                wait(1.0);
            }
        }else if (mode=='5'){
            pc.printf("5:Fast Cherge Mode\n\r");
            float bt;
            battery.vol(&bt);
            pc.printf("V = %f\r\n",bt);
            wait(3.0);
            while(1) {
                battery.fast_charge();
            }
        }else if (mode=='6'){
            pc.printf("6:SD Card Check Mode\n\r");
            mkdir("/sd/mydir", 0777);
            FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
            if(fp == NULL) {
                error("Could not open file for write\n");
            }
            fprintf(fp, "Hello My name is HEPTA!");
            fclose(fp);
        }else if (mode=='7'){
            pc.printf("7:Storing Battery Voltage to SD Card Mode\n\r");
            float bt;
            int i;
            mkdir("/sd/mydir", 0777);
            FILE *fp = fopen("/sd/mydir/battery.txt", "w");
            if(fp == NULL) {
                error("Could not open file for write\n");
            }
            for(i=1;i<=10;i++){
                battery.vol(&bt);
                pc.printf("Vol = %f\r\n",bt);
                fprintf(fp,"%f\r\n",bt);
                wait(1.0);
            }
            fclose(fp);
            pc.printf("End\n\r");
        }else if (mode=='8'){
            pc.printf("8:Gyro Sensor Mode\n\r");
            float gx,gy,gz;
            pc.printf("X Y Z\r\n");
            while(1){
                gyro.sensing(&gx,&gy,&gz);
                pc.printf("%2.5f %2.5f %2.5f\r\n",gx,gy,gz);
                wait(1.0);
            }
        }else if (mode=='9'){
            pc.printf("9:Accel Sensor Mode\n\r");
            float ax,ay,az;
            pc.printf("X Y Z\r\n");
            while(1){
                accel.sensing(&ax,&ay,&az);
                pc.printf("%2.5f %2.5f %2.5f\r\n",ax,ay,az);
                wait(1.0);
            }
        }else if (mode=='a'){
            pc.printf("a:GPS Sensor Mode\n\r");
            float lad,log;
            while(1) {
                gps.sensing(&lad,&log); 
                pc.printf("Lad = %2.5f Log =%2.5f\r\n",lad,log);
            }
        }else if (mode=='b'){
            pc.printf("b:Camera Mode\n\r");
            //camera.shoot2();
            camera.shoot();
            wait(10);
            pc.printf("Finish!!\n\r");
        }else if (mode=='c'){
            pc.printf("c:LCD Mode\n\r");
            int i;
            lcd.printf(0,"Hello\r");
            lcd.printf(1,"World\r");
            for(i=1;i<10;i++){
                lcd.printf(0,"num = %d\r",i);
                wait(1.0);
            }
        }else if (mode=='d'){
            pc.printf("d:Voice Mode\r\n");
            talk.Synthe("konnichiha\r");
            break;
        }else if (mode=='e'){
            pc.printf("e:Xbee Mode\r\n");
            int i=0,rcmd=0,cmdflag=0;
            //xbee_serial.printf("Count Up!\r");
            xbee.printf("Count Up!\r");
            while(1){
                //xbee_serial.printf("num = %d\r",i);
                xbee.printf("num = %d\r",i);
                i++;
                wait(1.0);
                xbee.xbee_recieve(&rcmd,&cmdflag);
                pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
                if (cmdflag == 1){
                    if (rcmd == 'a'){
                        pc.printf("Command Get %d\r\n",rcmd);
                        xbee.printf("HEPTA Uplink OK\r");
                    }
                    xbee.initialize();
                }
            }
        }else if(mode=='f'){ 
            pc.printf("f:All Data Downlink to Pc Mode\r\n");
            char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],lad[8],log[8],bt[4];
            char ddata[44];
            int dsize[4];
            while(1) {
                gyro.sensing_u16(gx,gy,gz,&dsize[0]);
                accel.sensing_u16(ax,ay,az,&dsize[1]);
                gps.sensing_u16(lad,log,&dsize[2]);
                battery.vol_u16(bt,&dsize[3]);
                //gyro.x_u16(gx,4);
                pc_transmit(ddata,44,gx,gy,gz,ax,ay,az,lad,log,bt,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[3],9);      
            }
        }else if(mode=='g'){ 
            pc.printf("g:All Data Downlink to Pc by Xbee Mode\r\n");
            char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],lad[8],log[8],bt[4];
            char ddata[44];
            int dsize[4];
            while(1) {
                gyro.sensing_u16(gx,gy,gz,&dsize[0]);
                accel.sensing_u16(ax,ay,az,&dsize[1]);
                gps.sensing_u16(lad,log,&dsize[2]);
                battery.vol_u16(bt,&dsize[3]);
                //gyro.x_u16(gx,4);
                xbee.xbee_transmit(ddata,44,gx,gy,gz,ax,ay,az,lad,log,bt,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[3],9);      
            }
        }else if(mode=='h'){ 
            pc.printf("h:High speed sensing mode for gyro & accel Mode\r\n");
            char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],lad[8],log[8],bt[4];
            char ddata[44];
            int dsize[4];
            lad[0] = '0';
            lad[1] = '0';
            lad[2] = '0';
            lad[3] = '0';
            lad[4] = '0';
            lad[5] = '0';
            lad[6] = '0';
            lad[7] = '0';
            log[0] = '0';
            log[1] = '0';
            log[2] = '0';
            log[3] = '0';
            log[4] = '0';
            log[5] = '0';
            log[6] = '0';
            log[7] = '0';
            dsize[2] = 8;
            //pc.printf("test");
            wait(5.0);
            while(1) {
                //pc.printf("test2");
                gyro.sensing_u16(gx,gy,gz,&dsize[0]);
                accel.sensing_u16(ax,ay,az,&dsize[1]);
                //gps.sensing_u16(lad,log,&dsize[2]);
                battery.vol_u16(bt,&dsize[3]);
                //gyro.x_u16(gx,4);
                //pc.printf("ffff");
                wait(0.001);              
                pc_transmit(ddata,44,gx,gy,gz,ax,ay,az,lad,log,bt,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[3],9);      
                //pc.printf("cccc");
            }
        }else if(mode=='i'){ 
            pc.printf("i:High speed sensing mode and caluclate to deg\r\n");
            float gx_ang,gy_ang,gz_ang;
            float dt;
            float gx,gy,gz;
            //char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],lad[8],log[8],bt[4];
            char ddata[44];
            int dsize[4];
            /*lad[0] = '0';
            lad[1] = '0';
            lad[2] = '0';
            lad[3] = '0';
            lad[4] = '0';
            lad[5] = '0';
            lad[6] = '0';
            lad[7] = '0';
            log[0] = '0';
            log[1] = '0';
            log[2] = '0';
            log[3] = '0';
            log[4] = '0';
            log[5] = '0';
            log[6] = '0';
            log[7] = '0';
            dsize[2] = 8;*/
            //pc.printf("test");
            wait(5.0);
            dt = 0.001;
            while(1) {
                //pc.printf("test2");
                gyro.sensing(&gx,&gy,&gz);
                //gyro.sensing_u16(gx,gy,gz,&dsize[0]);
                //accel.sensing_u16(ax,ay,az,&dsize[1]);
                //gps.sensing_u16(lad,log,&dsize[2]);
                //attery.vol_u16(bt,&dsize[3]);
                //gyro.x_u16(gx,4);
                //pc.printf("ffff");
                //gyro data to deg
                    gx_ang += (((gx+1.92556)))*dt;
                    gy_ang += (((gy+0.41286)))*dt;
                    gz_ang += (((gz-0.820308)))*dt;
                pc.printf("%2.5f %2.5f %2.5f\r\n",gx_ang,gy_ang,gz_ang);
                //pc.printf("%2.5f %2.5f %2.5f\r\n",gx+1.92556,gy+0.41286,gz-0.820308);
                wait(0.001);              
                //pc_transmit(ddata,44,gx,gy,gz,ax,ay,az,lad,log,bt,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[3],9);      
                //pc.printf("cccc");
            }
        }else{
            pc.printf("Under construction!!!\r\n");
        }
    }
}
