/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Game of Snake
@brief Revision 1.0.
@author Michael Birney 
@date   April 2015
*/

#include <vector>
#include "mbed.h"
#include "N5110.h"
#include "PinDetect.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#define DIRECTION_TOLERANCE 0.1

#define USR_POWERDOWN (0x104)
int semihost_powerdown(){
    
uint32_t arg;
return __semihost(USR_POWERDOWN,& arg);
}

AnalogIn pot(p20);
PwmOut Buzzer(p21);

//        VCC,SCE,RST,D/C,MOSI,SCLK,LED

/** 
@namespace lcd
@brief connections lcd mosi connections for nokia N5110
*/ 
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

/** 
@namespace myleds
@brief busout to onboard mbed LEDS for debug
*/ 

BusOut myleds(LED1,LED2,LED3,LED4);

/** 
@namespace leds
@brief bus output for game indicator leds 
*/ 
BusOut leds(p22,p23,p24);

/** 
@namespace startButton
@PinDetect for start button ISR
*/ 
PinDetect startButton(p5);
/** 
@namespace resetButton
@Interrupt in for reset button ISR
*/ 
InterruptIn resetButton(p6);

int score=5; /*!< integer to store user score */

/** 
@namespace startGame
@brief Ticker to set updateGameFlag 
*/ 
Ticker startGame;


char buffer[14]; /*!< stores data to print to screen */
int length = sprintf(buffer,"%2d",score); // print formatted data to buffer
// it is important the format specifier ensures the length will fit in the buffer
// connections for joystick

/** 
@namespace button 
@brief Joysitck button GPIO 
*/ 
PinDetect button(p17);
/** 
@namespace xPot 
@brief joystick x pot GPIO
*/ 
AnalogIn xPot(p15);
/** 
@namespace yPot 
@brief joystick y pot GPIO 
*/ 
AnalogIn yPot(p16);
//for debug

/** 
@namespace serial 
@brief Print to terminal for debug 
*/ 
Serial serial(USBTX,USBRX);

//forGame

bool gamePaused=0; /*!< bool to store paused state */
vector<int> snakeX (5); /*!<vector to store all x coordinates of snake */ 
vector<int> snakeY (5,27);/*!< vector to store all y coordinates of snake */ 
int foodX[1];/*!< int to store x value of food */
int foodY[1];/*!< int to store y value of food */
int gameState=0;/*!<indicator for various game states */ 


float gameSpeed;/*!< changes depending on difficulty selected */
int updateGameFlag=0; /*!< ISR to update game */


// GAME MENU

/** 
Displays a Snake Logo Splash Screen 
*/
void displaySplash();

/** 
Reads default positions of the joystick to calibrate later readings 
*/
void calibrateJoystick();

/** 
Reads X and Y pots and determines what direction joystick is in 
*/
void updateJoystick();

/** 
Displays easy selected on display and updates gameSpeed variable
*/
void easySelected();
/** 
Displays Medium selected on display and updates gameSpeed variable
*/
void mediumSelected();
/** 
Displays Hard selected on display and updates gameSpeed variable
*/
void hardSelected() ;

/** 
Displays classicMode selected on display and updates gameMode variable
*/
void classicModeSelected();

/** 
Displays BoundaryMode selected on display and updates gameMode variable
*/
void boundaryModeSelected();

/** 
Uses joystick direction to determine what difficulty too update to
*/
void checkSelectedGameMode();

/** 
Uses joystick direction to determine what game mode too update to
*/
void checkSelectedDifficulty();


//GAMEPLAY


/** 
resizes the vector back to 5 incase game is reset
prints to screen using coordinates stored in the snakeX and snakeY vectors
drawRect used for 2x2 snake
*/
void startingSnake();


/** 
Funtion to generate random food 
*/
void randomiseFood();


/** 
prints a solid boundary around screen for use in BOUNDARY mode
*/
void hardBoundary();

/** 
Prints a dotted boundary around the screen for use in CLASSIC mode
*/
void classicBoundary();


/** 
Uses joystick direction and previous joysitck direction to determine new direction of snake
Clears Tail of Snake
Elements in SnakeX and Y are shifted along one to the right 
New snake head cordinates are added to last element of vector depending on direction
*/
void updateSnakeVector();

/** 
triggers Buzzer to play when gameover
*/
void gameOverTune();

/** 
called when game is over.
displays final score for user 
*/
void gameOver();


/** 
called in boundary mode
everytime snake updates checks for a collision with boundary
*/
void checkForCollision();


/** 
Everytime snake is updated 
compares coordinates of snake to the food to see if they match
*/
void checkForFood();


/** 
function called when pindetect startButton is triggered
*/
void startButtonPressed();


/** 
Reads from brightness potentiometer to update lcd brightness
*/
void updateBrightness();


/** 
function called by updateGame timer
*/
void updateGameISR();


/** 
For debug. Prints content of snakeX and snakeY vectors
*/
void printVectorContent();

/** 
function called when interupt occurs on joystick button
*/
void pauseButtonPressed();


/** 
Compares all elements in snake vectors against head of snake
@param i - integer signifying element in snake vector
*/
void checkForCollisionWithSelf(int i);



