//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

/*
  Pixy.h - Library for interfacing with Pixy.
  Created by Scott Robinson, October 22, 2013.
  Released into the public domain.

  06.04.2014 v0.1.3 John Leimon 
    + LinkSPI.init() should be called from the setup() 
      function instead of being called automatically from
      the TPixy<LinkSPI> constructor in global scope. This
      is a workaround for a bug (?) in the Arduino DUE in which
      calling SPI.begin() from global scope (via a constructor)
      inhibits the operation of the Serial peripheral in the
      DUE. [As of: Arduino 1.5.6-r2]
*/

#ifndef PIXY_H2
#define PIXY_H2

#include "TPixy2.h"
#include "SPI2.h"


#define PIXY_SYNC_BYTE2              0x5a
#define PIXY_SYNC_BYTE_DATA2         0x5b
#define PIXY_OUTBUF_SIZE2            6

SPI spi2(p11, p12, p13); // mosi, miso, sclk

class LinkSPI2
{
  public:
    void init2()
    {
      outLen2 = 0;
      #ifdef __SAM3X8E__
      // DUE clock divider //
      SPI.setClockDivider2(84);
      #else
      // Default clock divider //
      //SPI.setClockDivider(SPI_CLOCK_DIV16);
      #endif
    }
    
    uint16_t getWord2()
    {
      // ordering is different because Pixy is sending 16 bits through SPI 
      // instead of 2 bytes in a 16-bit word as with I2C
      uint16_t w2;
      uint8_t c2, count2 = 0;

      if (outLen2)
      {
        w2 = spi2.write(PIXY_SYNC_BYTE_DATA2);
        count2 = outBuf2[outIndex2++];
        if (outIndex2==outLen2)
          outLen2 = 0; 
      }
      else
        w2 = spi2.write(PIXY_SYNC_BYTE2);
      w2 <<= 8;
      c2 = spi2.write(count2);
      w2 |= c2;

      return w2;
    }

    uint8_t getByte2()
    {
      return spi2.write(0x00);
    }
    
    int8_t send(uint8_t *data2, uint8_t len2)
    {
      if (len2>PIXY_OUTBUF_SIZE2 || outLen2!=0)
        return -1;
      memcpy(outBuf2, data2, len2);
      outLen2 = len2;
      outIndex2 = 0;
      return len2;
    }

    void setAddress2(uint8_t addr2)
    {
      addr_2 = addr2;
    }

  private:
    uint8_t outBuf2[PIXY_OUTBUF_SIZE2];
    uint8_t outLen2;
    uint8_t outIndex2;
    uint8_t addr_2;
};


typedef TPixy2<LinkSPI2> Pixy2;

#endif


