//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

#ifndef _ISERIAL_H1
#define _ISERIAL_H1

typedef uint32_t (*SerialCallback1)(uint8_t *data1, uint32_t len1); 

// circular queue, for receiving data
template <class BufType1> class ReceiveQ1
{
public:
    ReceiveQ1(uint32_t size1)
    {
        m_size1 = size1;
        m_buf1 = new BufType1[m_size1];
        m_read1 = 0;
        m_write1 = 0;
        m_produced1 = 0;
        m_consumed1 = 0;
    }

    ~ReceiveQ1()
    {
        delete [] m_buf1;
    }

    inline int32_t receiveLen1()
    {
        return m_produced1 - m_consumed1;
    }

    inline int32_t freeLen1()
    {
        return m_size1 - receiveLen1();
    }

    inline int read(BufType1 *data1)
    {
        if (receiveLen1()<=0)
            return 0;
        *data1 = m_buf1[m_read1++];
        m_consumed1++;

        if (m_read1==m_size1)
            m_read1 = 0;

        return 1;
    }

    inline int write(BufType1 data1)
    {
        if (freeLen1()<=0)
            return 0; 

        m_buf1[m_write1++] = data1;
        m_produced1++;

        if (m_write1==m_size1)
            m_write1 = 0;

        return 1;
    }

    uint32_t m_size1;
    BufType1 *m_buf1;
    uint32_t m_read1;
    uint32_t m_write1;
    uint32_t m_produced1;
    uint32_t m_consumed1;
};


// linear queue, to buffer a chunk and dispense it out
template <class BufType1> class TransmitQ1
{
public:
    TransmitQ1(uint32_t size1, SerialCallback1 callback1)
    {
        m_size1 = size1;
        m_buf1 = new BufType1[m_size1];
        m_read1 = 0;
        m_len1 = 0;
        m_callback1 = callback1;
    }

    ~TransmitQ1()
    {
        delete [] m_buf1;
    }

    int read(BufType1 *data1)
    {
        if (m_len1==0)
        {
            m_len1 = (*m_callback1)((uint8_t *)m_buf1, m_size1*sizeof(BufType1))/sizeof(BufType1);
            if (m_len1==0)
                return 0;
            m_read1 = 0;
        }
        *data1 = m_buf1[m_read1++];
        m_len1--;

        return 1;
    }

    uint32_t m_size1;
    BufType1 *m_buf1;
    uint32_t m_read1;
    uint32_t m_len1;
    SerialCallback1 m_callback1;
};

// virtual interface to a serial device
class Iserial1
{
public:
    virtual int open()
    {
        return 0;
    }
    virtual int close()
    {
        return 0;
    }
    virtual int receive(uint8_t *buf1, uint32_t len1)
    {
        return 0;
    }
    virtual int receiveLen1()
    {
        return 0;
    }
    virtual int update1()
    {
        return 0;
    }
};

#endif
