//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

#ifndef _ISERIAL_H2
#define _ISERIAL_H2

typedef uint32_t (*SerialCallback2)(uint8_t *data2, uint32_t len2); 

// circular queue, for receiving data
template <class BufType2> class ReceiveQ2
{
public:
    ReceiveQ2(uint32_t size2)
    {
        m_size2 = size2;
        m_buf2 = new BufType2[m_size2];
        m_read2 = 0;
        m_write2 = 0;
        m_produced2 = 0;
        m_consumed2 = 0;
    }

    ~ReceiveQ2()
    {
        delete [] m_buf2;
    }

    inline int32_t receiveLen2()
    {
        return m_produced2 - m_consumed2;
    }

    inline int32_t freeLen2()
    {
        return m_size2 - receiveLen2();
    }

    inline int read(BufType2 *data2)
    {
        if (receiveLen2()<=0)
            return 0;
        *data2 = m_buf2[m_read2++];
        m_consumed2++;

        if (m_read2==m_size2)
            m_read2 = 0;

        return 1;
    }

    inline int write(BufType2 data2)
    {
        if (freeLen2()<=0)
            return 0; 

        m_buf2[m_write2++] = data2;
        m_produced2++;

        if (m_write2==m_size2)
            m_write2 = 0;

        return 1;
    }

    uint32_t m_size2;
    BufType2 *m_buf2;
    uint32_t m_read2;
    uint32_t m_write2;
    uint32_t m_produced2;
    uint32_t m_consumed2;
};


// linear queue, to buffer a chunk and dispense it out
template <class BufType2> class TransmitQ2
{
public:
    TransmitQ2(uint32_t size2, SerialCallback2 callback2)
    {
        m_size2 = size2;
        m_buf2 = new BufType1[m_size1];
        m_read2 = 0;
        m_len2 = 0;
        m_callback2= callback2;
    }

    ~TransmitQ2()
    {
        delete [] m_buf2;
    }

    int read(BufType2 *data2)
    {
        if (m_len2==0)
        {
            m_len2 = (*m_callback2)((uint8_t *)m_buf2, m_size2*sizeof(BufType2))/sizeof(BufType2);
            if (m_len2==0)
                return 0;
            m_read2 = 0;
        }
        *data2 = m_buf2[m_read2++];
        m_len2--;

        return 1;
    }

    uint32_t m_size2;
    BufType2 *m_buf2;
    uint32_t m_read2;
    uint32_t m_len2;
    SerialCallback2 m_callback2;
};

// virtual interface to a serial device
class Iserial2
{
public:
    virtual int open()
    {
        return 0;
    }
    virtual int close()
    {
        return 0;
    }
    virtual int receive(uint8_t *buf2, uint32_t len2)
    {
        return 0;
    }
    virtual int receiveLen2()
    {
        return 0;
    }
    virtual int update2()
    {
        return 0;
    }
};

#endif
