//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

#ifndef _SPI_H1
#define _SPI_H1
#include "iserial1.h"

#define SPI_RECEIVEBUF_SIZE1     16
#define SPI_TRANSMITBUF_SIZE1    16

#define SS_ASSERT1()             LPC_SGPIO1->GPIO_OUTREG1 = 0;
#define SS_NEGATE1()             LPC_SGPIO1->GPIO_OUTREG1 = 1<<14;

#define SPI_SYNC_MASK1           0xff00
#define SPI_SYNC_WORD1           0x5a00
#define SPI_SYNC_WORD_DATA1      0x5b00
#define SPI_MIN_SYNC_COUNT1      5

class Spi1 : public Iserial1
{
public:
    Spi1(SerialCallback1 callback1);

    // Iserial methods
    virtual int open1();
    virtual int close1();
    virtual int receive1(uint8_t *buf1, uint32_t len1);
    virtual int receiveLen1();
    virtual int update1();

    void slaveHandler1();

private:
    int checkIdle1();
    int sync1();
    ReceiveQ1<uint16_t> m_rq1;
    TransmitQ1<uint16_t> m_tq1;

    bool m_sync1;
    uint32_t m_recvCounter1;
    uint32_t m_lastRecvCounter1; 
    uint8_t m_syncCounter1;
};

void SPIinit1(SerialCallback1 callback1);

extern Spi1 *g_spi1;

#endif