

#include "Pswitch.h"
 #include "mbed.h"
 
 /*
  * Constructor
  */
 Pswitch::Pswitch(PinName in) 
     : _in(in) {    
         
     // reset all the flags and counters    
     _samples = 0;
     _output = 0;
     _output_last = 0;
     _rising_flag = 0;
     
     // Attach ticker
     _ticker.attach(this, &Pswitch::_sample, 0.005);     
 }
   
 void Pswitch::_sample() {
 

	_output_last = _output;
	_output = _in;
	if (!_output && _output_last)
	{
		_rising_flag++;
	}

}

 
 
 
 // return number of rising edges
 int Pswitch::count(void) {
     int return_value = _rising_flag; 
     _rising_flag = 0;
     return(return_value);
 }
 
 // return the debounced status
 int Pswitch::read(void) {
     return(_in);
 }
 
 // shorthand for read()
 Pswitch::operator int() {
     return read();
 }
