#include "mbed.h"

DigitalOut gpo(D0);
DigitalOut ledR(LED_RED);
DigitalOut ledG(LED_GREEN);
DigitalOut ledB(LED_BLUE);

//mbed.h por su cuenta tiene la lista de pines para el LED segun la plaqueta

//TODO
//falta funcion random para ciclar entre colores

float Estado[3] = {1.0f, 1.0f, 1.0f};

bool LEDManual(float R, float G, float B) {
    if ((R <= 1.0f) && (G <= 1.0f) && (B <= 1.0f) && (R >= 0.0f) && (G >= 0.0f) && (B >= 0.0f)){
        ledR = R;
        ledG = G;
        ledB = B;
        
        Estado[0] = ledR;
        Estado[1] = ledG;    
        Estado[2] = ledB; 
        return true;
    } else {
        LEDManual(Estado[0], Estado[1], Estado[2]);
        return false;
    }
} 

bool LEDColor(char C) {
    bool b = true;
    
    switch (C) {
    case 'R':
        LEDManual(0.0f, 1.0f, 1.0f);
        break;
    case 'G':
        LEDManual(1.0f, 0.0f, 1.0f);
        break;
    case 'B':
        LEDManual(1.0f, 1.0f, 0.0f);
        break;
    case 'Y':
        LEDManual(0.0f, 0.0f, 1.0f);
        break;
    case 'M':
        LEDManual(0.0f, 1.0f, 0.0f);
        break;
    case 'C':
        LEDManual(1.0f, 0.0f, 0.0f);
        break;
    case 'W':  
        LEDManual(0.0f, 0.0f, 0.0f);
        break;
    default:
        b = false;
        break;        
    }
    
    if (b) {
        Estado[0] = ledR;
        Estado[1] = ledG;
        Estado[2] = ledB;    
    }
    
    return b;
}

void LEDEstado(bool b) {
    if (b) { 
        LEDManual(Estado[0], Estado[1], Estado[2]);          
    } else {
        ledR = 1.0f;
        ledG = 1.0f;
        ledB = 1.0f;
    }
}

