#include "mbed.h"
#include "FastPWM.h"
#include "MODSERIAL.h"

Ticker motor; // Ticker function
FastPWM pwmpin1(D5); // SPECIFIC PIN (hoeft niet aangesloten te worden) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
FastPWM pwmpin2(D6); // SPECIFIC PIN (hoeft niet aangesloten te worden) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
DigitalOut directionpin1(D4); // SPECIFIC PIN (hoeft niet aangesloten te worden) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
DigitalOut directionpin2(D7); // SPECIFIC PIN (hoeft niet aangesloten te worden) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
AnalogIn potmeter1(A4); // Analoge input van potmeter 1 -> Motor 1
AnalogIn potmeter2(A2); // Analoge input van potmeter 2 -> Motor 2

volatile float pot1;
volatile float pot2;
volatile float pot1_scale;
volatile float pot2_scale;
volatile float u1;
volatile float u2;

void motorfunction()
{       pot1 = potmeter1.read();          // reads out value potmeter 1 between 0-1
        pot1_scale = pot1*2 -1;           // scales value potmeter from 0-1 to -1 - 1.
        pot2 = potmeter2.read();          // reads out value potmeter 2 between 0-1 
        pot2_scale = pot2*2 -1;           // scales value potmeter from 0-1 to -1 - 1.        
        u1 = pot1_scale;                  // motor control signal
        u2 = pot2_scale;                  // motor control signal
        directionpin1 = u1 > 0.0f;        // either true or false, determines direction (0 or 1)
        directionpin2 = u2 > 0.0f;        // either true or false
        pwmpin1 = fabs(u1);               // pwm duty cycle can only be positive, floating point absolute value (if value is >0, the there still will be a positive value).
        pwmpin2 = fabs(u2);               // pwm duty cycle can only be positive, floating point absolute value (if value is >0, the there still will be a positive value).
}

int main()
{
    pwmpin1.period_us(60.0); //60 microseconds PWM period, 16.7 kHz, defines all PWM pins (only needs to be done once)
    motor.attach(motorfunction,0.5);
    while(true){} //Lege while loop zodat functie niet afloopt
}