#include "mbed.h"
#include "MPR121.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC11U24)
I2C i2c(p28, p27);
InterruptIn irq(p26);
MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);
#define LED_ON  1
#define LED_OFF 0

#elif defined(TARGET_KL25Z)
I2C i2c(PTC9, PTC8);
InterruptIn irq(PTA5);
MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);
#define LED_ON  0
#define LED_OFF 1

#elif defined(TARGET_LPC11U68) || defined(TARGET_LPC824)
I2C i2c(A4, A5);
InterruptIn irq(D2);
MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);
#define LED_ON  0
#define LED_OFF 1

#else
#error TARGET NOT TESTED
#endif

const int key_tbl[9] = {
    9,
    6,
    3,
    8,
    5,
    2,
    7,
    4,
    1,
};

int main()
{
    touch_pad.init();
    touch_pad.enable();
    touch_pad.registerDump(pc);

    while(1) {
        if(touch_pad.isPressed()) {
            uint16_t button_val = touch_pad.buttonPressed();
            if (button_val != 0) {
                for(int i=0; i<=9; i++) {
                    if ((button_val & (1 << i)))
                        pc.printf("%d", key_tbl[i]);
                }
            } else {
                pc.printf("\n");
            }
            myled = (button_val>0) ? LED_ON : LED_OFF;
        }
    }
}
