#ifndef _MAIN_H_
#define _MAIN_H_ included

#if   defined (TARGET_KL25Z) 
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define PIN_RESET_TFT   PTB10
 
#elif defined (TARGET_KL46Z)
#define PIN_MOSI        PTD6
#define PIN_MISO        PTD7 
#define PIN_SCLK        PTD5 
#define PIN_CS_TFT      PTD4 
#define PIN_DC_TFT      PTD2 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define PIN_RESET_TFT   PTB10

#elif defined (TARGET_ARM_MPS2_M7)
#define PIN_MOSI        CLCD_MOSI
#define PIN_MISO        CLCD_MISO
#define PIN_SCLK        CLCD_SCLK
#define PIN_CS_TFT      CLCD_SSEL 
#define PIN_DC_TFT      PTD2 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define PIN_RESET_TFT   CLCD_RESET

//#elif defined (TARGET_K64F)
#else
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D10
#define PIN_DC_TFT      D9
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4
#define PIN_CS_TSC      D8
#define PIN_TSC_INTR    D7
#define PIN_RESET_TFT   LED1

//#else
//  #error TARGET NOT DEFINED
#endif

#endif /* _MAIN_H_ */