/**
 *  MFT2015 demo : shake-shake-machine
 *
 *  @author  Toyomasa WATARAI
 *  @version 1.0
 *  @date    24-July-2015
 *
 *
 */

#include "mbed.h"
#include "PCA9622_LED8x8.h"
#include "font3x5.h"
#include "tone_table.h"

PCA9622_LED8x8  matrix(D14, D15);
AnalogIn ain(A0);
PwmOut out(D4);
Serial pc(USBTX, USBRX);

#define DURATION_TIME (5 * 1000) // n * milisecond

void draw_number(int num, int reverse=0);

void draw_number(int num, int reverse)
{
    float   image[8][8];
    num %= 100;

    for (int x=0; x<8; x++)
        for (int y=0; y<8; y++) {
            if (reverse)
                image[x][y] = 0.5f;
            else
                image[x][y] = 0.0f;
        }

    for (int i=0; i<5; i++) {
        for (int j=0; j<3; j++) {
            if (((font3x5[((num/10)*3) + j]) & (1<<(4-i))) != 0) {
                if (reverse)
                    image[i+1][j+1] = (float)0.0f;
                else
                    image[i+1][j+1] = (float)0.5f;
            } else {
                if (reverse)
                    image[i+1][j+1] = (float)0.5f;
                else
                    image[i+1][j+1] = (float)0.0f;
            }
        }
    }

    for (int i=0; i<5; i++) {
        for (int j=0; j<3; j++) {
            if (((font3x5[((num%10)*3) + j]) & (1<<(4-i))) != 0) {
                if (reverse)
                    image[i+1][j+5] = (float)0.0f;
                else
                    image[i+1][j+5] = (float)0.5f;
            } else {
                if (reverse)
                    image[i+1][j+5] = (float)0.5f;
                else
                    image[i+1][j+5] = (float)0.0f;
            }
        }
    }

    matrix.set_data( image );
}


void count_down(int cnt)
{
    for(int i=cnt; i>0; i--) {
        draw_number(i);
        out.period_us(tone_table_us[1]);
        out.write(0.5f);
        wait(0.5);
        out.period(0);
        wait(0.5);
    }
    draw_number(0);
    out.period_us(tone_table_us[13]);
    out.write(0.5f);
}

int main()
{
    int count = 0;
    float f = 0;
    float vv;
    Timer timer;

    timer.reset();
    matrix.start();

    count_down(3);

    timer.start();
    while(1) {
        if ( timer.read_ms() > 1000) {
            out.period(0);
        }
        vv = ain.read();

        if ( abs(f - vv) >= 0.015f) {
            count++;
            pc.printf("*");
            draw_number(count);
        }
        f = vv;
        wait(0.1);
        if ( timer.read_ms() > DURATION_TIME) {
            pc.printf("count = %d\n", count);
            draw_number(count);
            break;
        }
    }

    out.period_us(tone_table_us[13]);
    out.write(0.5f);
    wait(1);
    out.period(0);

    while(1) {
        draw_number(count, 0);
        wait(1);
        draw_number(count, 1);
        wait(1);

    }
}
