/**
 * X'mas tree LED blinky using NeoPixel
 *
 * Copyright (C) 2015 Toyomasa Watarai (MACRUM)
 */

#include "mbed.h"
#include "LEDStrip.h"

#define START_ID  2
#define NUM_LEDS  10
#define MAX_LEVEL 100

Ticker blinker0, blinker1, blinker2, blinker3, blinker4, blinker5, blinker6, blinker7, blinker8, blinker9;
int led_val[NUM_LEDS];

void blink_1()
{
    for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, i, i, i);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
    for( int i=MAX_LEVEL ; i >= 0 ; i-- ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, i, i, i);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
}

void blink_2()
{
    for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, i, 0, 0);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
    for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, MAX_LEVEL, i, 0);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
    for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, MAX_LEVEL, MAX_LEVEL, i);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
    for( int i=MAX_LEVEL ; i >= 0 ; i-- ) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            tapeSet(j, i, i, i);	// LED No , Red , Green , Blue
        }
        tapeSend();
        wait_ms(15);
    }
}

void blink_3()
{
    for( int i = START_ID ; i <= (START_ID + NUM_LEDS); i++) {
        for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
            if ( i == j) {
                tapeSet(j, MAX_LEVEL, 0, 0);	// LED No , Red , Green , Blue
            } else {
                tapeSet(j, 0, 0, 0);	// LED No , Red , Green , Blue
            }

        }
        tapeSend();
        wait_ms(100);
    }
}

#define WAIT_TIME0 0.19
#define WAIT_TIME1 0.25
#define WAIT_TIME2 0.3
#define WAIT_TIME3 0.2
#define WAIT_TIME4 0.22
#define WAIT_TIME5 0.3
#define WAIT_TIME6 0.17
#define WAIT_TIME7 0.24
#define WAIT_TIME8 0.18
#define WAIT_TIME9 0.28

#define INTERVAL0 9
#define INTERVAL1 14
#define INTERVAL2 20
#define INTERVAL3 17
#define INTERVAL4 30
#define INTERVAL5 20
#define INTERVAL6 25
#define INTERVAL7 17
#define INTERVAL8 22
#define INTERVAL9 19

extern int wakeup;

#define led_event(i) \
	tapeSet(START_ID + 0, led_val[i], led_val[i], led_val[i]); \
	wakeup = 1; \
	if (led_val[i] <= 0) \
        led_val[i] = MAX_LEVEL; \
    else \
        led_val[i] -= INTERVAL##i; \
    if (led_val[i] < 0) \
        led_val[i] = 0;


void led0_event() {
	led_event(0);
}

void led1_event() {
	led_event(1);
}

void led2_event() {
	led_event(2);
}

void led3_event() {
	led_event(3);
}

void led4_event() {
	led_event(4);
}

void led5_event() {
	led_event(5);
}

void led6_event() {
	led_event(6);
}

void led7_event() {
	led_event(7);
}

void led8_event() {
	led_event(8);
}

void led9_event() {
	led_event(9);
}

#define start_led(i) \
	led_val[i] = MAX_LEVEL; \
	blinker##i.attach(&led##i##_event, WAIT_TIME##i);

#define stop_led(i) blinker##i.detach();

void blink_4()
{
    start_led(0);
    start_led(1);
    start_led(2);
    start_led(3);
    start_led(4);
    start_led(5);
    start_led(6);
    start_led(7);
    start_led(8);
    start_led(9);

    wait(8);

    stop_led(0);
    stop_led(1);
    stop_led(2);
    stop_led(3);
    stop_led(4);
    stop_led(5);
    stop_led(6);
    stop_led(7);
    stop_led(8);
    stop_led(9);
}

int main()
{
    const int loops = 3;
    tapeInit(0, START_ID + NUM_LEDS);	// freq( 0:default ) , SerialLED num

    int i = 0;
    while(1) {
        if ((i/loops) == 0) {
            blink_4();
        }
        if ((i/loops) == 1) {
            blink_2();
        }
        if ((i/loops) == 2) {
            blink_3();
        }
        if ((i/loops) == 3) {
            blink_1();
        }

        i++;
        if (i >= (loops * 4)) {
            i = 0;
        }
    }
}
