/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "FXOS8700Q.h"

I2C i2c(PTE25, PTE24);
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);

DigitalOut led(LED1);

int main(void)
{
    motion_data_counts_t mag_raw;
    int16_t raX, raY, raZ;

    // 磁気センサーの初期化
    mag.enable();

    while (true) {
        // データの取得
        mag.getAxis(mag_raw);
        mag.getX(raX);
        mag.getY(raY);
        mag.getZ(raZ);

        // LED点滅
        if (raY > -10 && raY < 10)
            led = 0;
        else
            led = 1;

        // データの出力
        printf("X: %d, Y: %d, Z:%d\n", raX, raY, raZ);
        wait(0.2f);
    }
}