#include "mbed.h"

DigitalOut led1(LED1);
I2C i2c(D14, D15);

// main() runs in its own thread in the OS
int main() {
    char buf[10];
    buf[0] = 0;
    printf("     0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\n");
    for (int adrs = 0; adrs < 0x80; adrs += 16) {
        printf("%02x: ", adrs);
        for (int i = 0; i < 16; i++) {
            i2c.write(((adrs + i) << 1), buf, 1);
            int ret = i2c.read(((adrs + i) << 1), buf, 2);
            if ((adrs+i) == 0 || (adrs+i) == 1 || (adrs+i) == 2) {
                printf("   ");
                continue;
            }
            if ((adrs+i) >= 0x78) {
                printf("\n");
                break;
            }
            if (ret == 1) {
                printf("-- ");
            }
            if (ret == 0) {
                printf("%02x ", (adrs + i) << 1);
            }
        }
        printf("\n");
    }
        
    while (true) {
        led1 = !led1;
        thread_sleep_for(0.5);
    }
}

