#include "mbed.h"
#include "msgpack-embedded.h"

int main(void) {

        /* creates buffer and serializer instance. */
        msgpack_sbuffer* buffer = msgpack_sbuffer_new();
        msgpack_packer* pk = msgpack_packer_new(buffer, msgpack_sbuffer_write);

        msgpack_sbuffer_clear(buffer);
        msgpack_pack_array(pk, 2);      // number of array
        
        msgpack_pack_uint8(pk, 2);      // e.g. sensor ID
        msgpack_pack_uint8(pk, 19);     // e.g. distance (cm)
        
        printf("buffer size = %d\n", buffer->size);

        printf("buffer = ");
        for(int i = 0; i < buffer->size; i++) {
            printf("0x%02x, ", buffer->data[i]);
        }
        printf("\n");

        /* cleaning */
        msgpack_sbuffer_free(buffer);
        msgpack_packer_free(pk);
}