/* Drum pad demo program
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *  *
 *  @author  Toyomasa Watarai
 *  @version 1.0
 *  @date    10-March-2016
 *
 *  Sparkfun Touch Sheild
 *  eVY1 board
 *  LPCXpresso842-MAX
 *
 */

#include "mbed.h"
#include "MPR121.h"

DigitalOut myled(LED1);
I2C i2c(A4, A5);
InterruptIn irq(D2);

#define LED_ON    0
#define LED_OFF   1
#define NUM_PADS 12

MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);
RawSerial midi(D1, NC);

const int key_tbl[NUM_PADS] = {
    38, // 0  Snare Drum 1
    39, // 1  Hand Clap
    46, // 2  Open Hi-hat
    42, // 3  Closed Hi-hat

    49, // 4  Crash Cymbal 1
    48, // 5  High Tom 2
    45, // 6  Mid Tom 2
    41, // 7  Low Tom 2

    56, // 8  Cowbell
    51, // 9  Ride Cymbal 1
    52, // 10 Chinese Cymbal
    36, // 11 Bass Drum 1
    
};

int key_pressed[NUM_PADS];

int main()
{
    touch_pad.init();
    touch_pad.enable();

    midi.baud(31250);
    wait(3.5);    // Wait few seconds for booting eVY1-Shleld.

    const uint8_t aMsgVol[] = "\xB9\x07\x70";
    for (uint32_t i = 0; i < sizeof(aMsgVol)-1; midi.putc(aMsgVol[i++]));

    while(1) {
        if(touch_pad.isPressed()) {
            uint16_t button_val = touch_pad.buttonPressed();
            if (button_val != 0) {
                for(int i=0; i<NUM_PADS; i++) {
                    if ((button_val & (1 << i))) {
                        if (key_pressed[i] == 0) {
                            midi.putc(0x99);       // note on CH10
                            midi.putc(key_tbl[i]); // note number
                            midi.putc(100);        // velocity
                            key_pressed[i] = 1;
                        }
                    } else {
                        key_pressed[i] = 0;
                    }
                }
            } else {
                for(int i=0; i<NUM_PADS; i++) {
                    if ((button_val & (1 << i)) == 0) {
                        key_pressed[i] = 0;
                        midi.putc(0x89);       // note off CH10
                        midi.putc(key_tbl[i]); // note number
                        midi.putc(0);          // velocity
                    }
                }
            }
            myled = (button_val>0) ? LED_ON : LED_OFF;
        }
    }
}
