/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Toyomasa Watarai
 * @brief   armcc pre-defined macro check progmra
 ******************************************************************************
 * @attention
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"

#define xstr(s) str(s)
#define str(s) #s

DigitalOut myled(LED1);

int main() {
    printf("\n");
    printf("System Clock = %ld\n", SystemCoreClock);
#ifdef MBED_USERNAME
    printf("mbed username: %s\n", xstr(MBED_USERNAME));
#endif
#ifdef MBED_LIBRARY_VERSION
    printf("mbed library version: %d\n", MBED_LIBRARY_VERSION);
#endif
#ifdef MBED_CONF_RTOS_PRESENT
    printf("Mbed OS %d.%d.%d\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
#endif

#ifdef __CC_ARM
#ifdef __MICROLIB
    printf("Built with ARM compiler and micro library (uARM)\n");
#else
    printf("Built with ARM compiler and standard library (ARM)\n");
#endif
    printf("ARM Compiler version : %d\n", __ARMCC_VERSION);

#ifdef __ARM_NEON__
    printf("NEON is available\n");
#else
    printf("NEON is not available\n");
#endif

#ifdef __APCS_INTERWORK
    printf("ARM/Thumb Interworking is used\n");
#endif

#ifdef __APCS_ROPI
    printf("--apcs /ropi is used\n");
#endif

#ifdef __APCS_RWPI
    printf("--apcs /rwpi is used\n");
#endif

#ifdef __APCS_FPIC
    printf("--apcs /fpic is used\n");
#endif

#ifdef __BIG_ENDIAN
    printf("Target is big endian\n");
#else
    printf("Target is little endian\n");
#endif

#ifdef __CHAR_UNSIGNED__
    printf("char type is unsigned\n");
#else
    printf("char type is signed\n");
#endif
    printf("EDG front-end version : %d\n", __EDG_VERSION__);

    printf("Emulated GNU version : %d.%d\n", __GNUC__, __GNUC_MINOR__);
    printf("Current emulated GNU version : %s\n", __VERSION__);

    printf("Optimize level : %d\n", __OPTIMISE_LEVEL);

#ifdef __OPTIMISE_SPACE
    printf("Optimized by size\n");
#endif

#ifdef __OPTIMISE_TIME
    printf("Optimized by speed\n");
#endif

    printf("Target ARM architecture : %d\n", __TARGET_ARCH_ARM);
    printf("Target Thumb architecture : %d\n", __TARGET_ARCH_THUMB);

#elif defined (__GNUC__)
#if defined (__ARMCC_VERSION)
    printf("Built with ARM compiler 6\n");
    printf("Arm compiler version %d\n", __ARMCC_VERSION);
#else
    printf("Built with GNU compiler\n");
#endif
    printf("Compatible GCC version %d.%d, %s\n", __GNUC__, __GNUC_MINOR__, __VERSION__);
    printf("Target ARM architecture : %d-%c\n", __ARM_ARCH, __ARM_ARCH_PROFILE);
#else
    printf("Not build with ARM compiler\n");
#endif

    printf("Compile date : %s\n", __DATE__);
    printf("Compile time : %s\n", __TIME__);


    while(1) {
        myled = !myled;
#if (MBED_MAJOR_VERSION >= 5) && (MBED_MINOR_VERSION >= 15)
        thread_sleep_for(400);
#else
        wait(0.4);
#endif
    }
}
