#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"

DigitalOut led1(D8);
DigitalOut led2(D9);
PwmOut     r(LED_RED);
PwmOut     g(LED_GREEN);
PwmOut     b(LED_BLUE);
AnalogIn   pot1(A0);
AnalogIn   pot2(A1);
LM75B      sensor(SDA, SCL);
InterruptIn button(D4);
MMA7660    axis(SDA, SCL);

C12832 lcd(D11, D13, D12, D7, D10);

Ticker flipper;

void flip()
{
    led2 = !led2;
}

int main()
{
    int cnt = 0;
    
    button.fall(&flip);
    flipper.attach(&flip, 1.23);
        
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("LPC1549 + mbed app shield!");
    led1 = 0;

    while(true) {
        lcd.locate(0,15);
        lcd.printf("Counting: %d", cnt);
        
        lcd.locate(70,15);
        lcd.printf("p1=%f", pot1.read());
                
        lcd.locate(70,15+8);
        lcd.printf("p2=%f", pot2.read());

        lcd.locate(20,15+8);
        lcd.printf("%f", sensor.read());

        r = axis.x();
        g = axis.y();
        b = axis.x();
        
        led1 = !led1;
        cnt++;
        wait(0.5);
    }
}
