/*
 * WS2812 tape led IC
 *
 *          0.35us   0.8us    (+-150ns)
 *  0:     |^^^^^|__________|
 *
 *             0.7us   0.6us  (+-150ns)
 *  1:     |^^^^^^^^^^|_____|
 *
 *               >50us
 *  RESET: |________________|
 */
#include "mbed.h"
#include "LEDStrip.h"

#if defined(TARGET_SSCI824)
SPI tape(dp2, NC, NC);
#else
SPI tape(p11, NC, NC);
#endif

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    LPC_SSP_TypeDef *_ssp = LPC_SSP0;
#elif defined(TARGET_LPC11U24)
    LPC_SSPx_Type *_ssp = LPC_SSP1;
#elif defined(TARGET_SSCI824)
    LPC_SPI0_Type *_ssp = LPC_SPI0;
#endif

int num = 100;
int *data;
volatile int busy = 0, wakeup = 0;


extern "C"
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
void SSP0_IRQHandler() {
#elif defined(TARGET_LPC11U24)
void SSP1_IRQHandler() {
#elif defined(TARGET_SSCI824)
void SPI0_IRQHandler() {
#endif
    static int addr = 0, bit = 0x800000;
repeat:
    if (busy) {
        // led data
#if defined(TARGET_SSCI824)
      while (_ssp->STAT & (1<<1)) { // TXRDY: Transmitter Ready flag.
#else
      while (_ssp->SR & (1<<1)) { // TNF: Transmit FIFO Not Full
#endif
        if (data[addr] & bit) {
            //_ssp->DR = 0x01f;
#if defined(TARGET_SSCI824)
			_ssp->TXDAT = 0x007;
#else
			_ssp->DR = 0x007;
#endif
        } else {
            // 0
#if (TARGET_SSCI824)
            _ssp->TXDAT = 0x07f;
#else
            _ssp->DR = 0x07f;
#endif
        }
        bit = bit >> 1;
        if (bit == 0) {
            bit = 0x800000;
            addr ++;
            if (addr >= num) {
                addr = 0;
                busy = 0;
                goto repeat;
            }
        }
      }
    } else {
        // blank
#if defined(TARGET_SSCI824)
        while (_ssp->STAT & (1<<1)) { // TXRDY: Transmitter Ready flag.
            _ssp->TXDAT = 0xfff; // Data register
#else
        while (_ssp->SR & (1<<1)) { // TNF: Transmit FIFO Not Full
            _ssp->DR = 0xfff; // Data register
#endif
            if (addr < 500) {
                addr ++;
            } else {
                addr = 0;
                if (wakeup) {
                    busy = 1;
                    wakeup = 0;
                    goto repeat;
                }
            }
        }
    }
}

void tapeInit (int freq, int n) {

    num = n;
//    data = new int(num);
    data = (int*)malloc(sizeof(int) * num);
    for (int i = 0; i < num; i ++) {
        data[i] = 0;
    }

    tape.format(10, 1);
    if (freq) {
        tape.frequency(freq * 1000);
    } else {
        tape.frequency(8000000);
    }
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    NVIC_SetVector(SSP0_IRQn, (uint32_t)SSP0_IRQHandler);
    NVIC_SetPriority(SSP0_IRQn, 0);
    NVIC_EnableIRQ(SSP0_IRQn);
#elif defined(TARGET_LPC11U24)
    NVIC_SetVector(SSP1_IRQn, (uint32_t)SSP1_IRQHandler);
    NVIC_SetPriority(SSP1_IRQn, 0);
    NVIC_EnableIRQ(SSP1_IRQn);
#elif defined(TARGET_SSCI824)
    NVIC_SetVector(SPI0_IRQn, (uint32_t)SPI0_IRQHandler);
    NVIC_SetPriority(SPI0_IRQn, 0);
    NVIC_EnableIRQ(SPI0_IRQn);
#endif

#if defined(TARGET_SSCI824)
    _ssp->INTENSET |= (1<<1); // TXRDYEN: An interrupt will be generated when data may be written to TXDAT.
#else
    _ssp->IMSC |= (1<<3); // TXIM: to enable interrupt when the Tx FIFO is at least half empty.
#endif
}

void tapeSet (int n, int dat) {
    if (n >= 0 && n < num) {
        // RGB -> GRB
        data[n] = ((dat & 0xff0000) >> 8) | ((dat & 0xff00) << 8) | (dat & 0xff);
    }
}
void tapeSet(int n, int red , int green , int blue) {
    if (n >= 0 && n < num) {
        // RGB -> GRB
        data[n] = ((red & 0xff) << 8) | ((green & 0xff) << 16) | (blue & 0xff);
    }
}

void tapeSend () {
    if (busy) {
        while (busy);
        wait_us(50);
    }
    wakeup = 1;
    while (wakeup);
}

int tapeGet (int n) {
    return ((data[n] & 0xff0000) >> 8) | ((data[n] & 0xff00) << 8) | (data[n] & 0xff);
}
