/**
 * X'mas tree LED blinky using NeoPixel
 *
 * Copyright (C) 2016 Toyomasa Watarai (MACRUM)
 */

#include "mbed.h"
#include "LEDStrip.h"

#define START_ID  2
#define NUM_LEDS  40
#define MAX_LEVEL 255

DigitalIn sensor(p17);
DigitalOut myled(LED1);

void blink_1(int);
void blink_2(int);
void blink_3(int);

void blink_1(int loops)
{
    while(loops--) {
        for (int idx = 0; idx < 8; idx++) {
            for (int j = START_ID; j <= (START_ID + NUM_LEDS); j += 7) {
                tapeSet(j+((idx+0)%7), 0, 0, 0);
                tapeSet(j+((idx+1)%7), 0, 0, MAX_LEVEL);
                tapeSet(j+((idx+2)%7), 0, MAX_LEVEL, 0);
                tapeSet(j+((idx+3)%7), 0, MAX_LEVEL, MAX_LEVEL);
                tapeSet(j+((idx+4)%7), MAX_LEVEL, 0, 0);
                tapeSet(j+((idx+5)%7), MAX_LEVEL, 0, MAX_LEVEL);
                tapeSet(j+((idx+6)%7), MAX_LEVEL, MAX_LEVEL, 0);
                tapeSet(j+((idx+7)%7), MAX_LEVEL, MAX_LEVEL, MAX_LEVEL);
            }
            tapeSend();
            wait_ms(300);
        }
    }
}


void blink_2(int loops)
{
    while(loops--) {
        for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
            for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
                tapeSet(j, i, 0, 0);	// LED No , Red , Green , Blue
            }
            tapeSend();
            wait_ms(10);
        }
        for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
            for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
                tapeSet(j, MAX_LEVEL, i, 0);	// LED No , Red , Green , Blue
            }
            tapeSend();
            wait_ms(10);
        }
        for( int i=0 ; i <= MAX_LEVEL ; i++ ) {
            for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
                tapeSet(j, MAX_LEVEL, MAX_LEVEL, i);	// LED No , Red , Green , Blue
            }
            tapeSend();
            wait_ms(10);
        }
        for( int i=MAX_LEVEL ; i >= 0 ; i-- ) {
            for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
                tapeSet(j, i, i, i);	// LED No , Red , Green , Blue
            }
            tapeSend();
            wait_ms(10);
        }
    }
}

void blink_3(int loops)
{
    while(loops--) {
        for( int i = START_ID ; i <= (START_ID + NUM_LEDS); i++) {
            for (int j = (START_ID + NUM_LEDS); j >= START_ID; j--) {
                tapeSet(j, MAX_LEVEL / ((( j - i ) - 1) * 5), 0, 0);	// LED No , Red , Green , Blue
            }
            tapeSend();
            wait_ms(50);
        }
    }
}

void clear(void)
{
    for (int j = START_ID; j <= (START_ID + NUM_LEDS); j++) {
        tapeSet(j, 0, 0, 0);	// LED No , Red , Green , Blue
    }
    tapeSend();
}

int main()
{
    tapeInit(0, START_ID + NUM_LEDS);	// freq( 0:default ) , SerialLED num
    sensor.mode(PullDown);
    int detect = sensor.read();

    while(1) {
        if (detect == 1) {
            myled = 1;
            blink_1(6);
            blink_2(1);
            blink_3(5);
            clear();
        }
        myled = 0;
        wait(0.5);
        detect = sensor.read();

    }
}
