#include "mbed.h"
#include "DigitDisplay.h"

#define D20 (PB_4)
#define D19 (PB_3)

DigitalOut GrovePower(PB_10, 1);
DigitalOut led1(D38);
AnalogIn ain(A6);
InterruptIn btn(D20);

DigitDisplay display(RXD, TXD); // 4-Digit Display connected to UART Grove connector

Ticker ticker;
volatile uint8_t second = 0;
volatile uint8_t minute = 0;
volatile uint8_t hour = 12;
volatile bool colon_enable = false;


///

float get_temp()
{
    const int B = 4275;               // B value of the thermistor
    const int R0 = 100000;            // R0 = 100k
    AnalogIn temp(A4);
    
    float R = 1.0f/temp.read() - 1.0f;
    R = R0*R;

    float temperature = 1.0/(log(R/R0)/B+1/298.15)-273.15; // convert to temperature via datasheet
    return temperature;
}
///


void tick()
{
    colon_enable = !colon_enable;
    display.setColon(colon_enable);

    if (colon_enable) {
        second++;
        if (second >= 60) {
            second = 0;
            minute++;
            if (minute >= 60) {
                minute = 0;
                hour++;
                if (hour >= 24) {
                    hour = 0;
                }
            }
            display.write(hour * 100 + minute);
        }
    }
}

void push()
{
        printf("*");
}

// main() runs in its own thread in the OS
int main()
{
    display.write(hour * 100 + minute);
    ticker.attach(tick, 0.5);
    
    btn.fall(push);

    int cnt = 0;
    printf("hello, Mbed world\n");
    while (true) {
        printf("count = %4d, analog = %f, temp = %f\n", cnt++, ain.read(), get_temp());
        led1 = !led1;
        wait(0.5);
    }
}

