#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"


/* wifly interface:
*     - p9 (TX) and p10 (RX) are for the serial communication
*     - p30 is for the reset pin
*     - p29 is for the connection status
*     - "ssid" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
#if TARGET_LPC1768
WiflyInterface wifly(p9, p10, p30, p29, "ssid", "password", WPA);
#else
WiflyInterface wifly(D1, D0, D3, D2, "ssid", "pasword", WPA);
#endif

DigitalOut led(LED1);

int main() {
    printf("Wifly WebSocket test\n");
    wifly.init(); //Use DHCP
    while (!wifly.connect());
    printf("IP Address is %s\n", wifly.getIPAddress());

    Websocket ws("ws://sockets.mbed.org/ws/443/wo");
    while (!ws.connect());

    while (1) {
            led = !led;
            ws.send("WebSocket Hello World over Wifly");
            wait(1.0);
    }
}