#include "mbed.h"
#include "C12832.h"
#include "GT20L16J1Y_font.h"

#include <locale.h>
#include <cwchar>
 
#pragma import __use_all_ctype
 
char  buf_s[80];
wchar_t wstr[80];

/* 
    GT20L16J1Y library test program
    works with mbed application board
*/

C12832 lcd(p5, p7, p6, p8, p11);
GT20L16J1Y_FONT font(p11, p12, p13, p10);

void draw_kanji(int offset_x, int offset_y)
{
    int color;
    for(int x=0; x<32; x++)
    {
        for(int y=0; y<8; y++)
        {
            if (font.bitmap[x] & (1<<y))
                color = 1;
            else
                color = 0;
            lcd.pixel(x%16 + offset_x, y+(8*(x>>4)) + offset_y, color);
        }
    }
    lcd.copy_to_lcd();
}

static int utf8tosjis(const char* utfBuffer, int utfBufLen, char* sjisBuffer, int sjisBufLen)
{
    int         i, wi;
    wchar_t     wc;
    mbstate_t   state = {0};
    size_t      ret;
    char *      current_locale;
    i = wi = 0;
 
    current_locale = setlocale(LC_CTYPE, "UTF-8");
    if (current_locale == NULL)
        return 0;
 
    while (1) {
        ret = mbrtowc(&wc, utfBuffer+i, 3, &state);
        if (ret == (size_t)-2 || ret == (size_t)-1) {
            //printf("\nThere was a problem decoding the multibyte string.\n");
            return ret;
        } else if (ret == 0) {
            break;          /* we hit \0, end of string */
        } else {
            i += ret;
            wstr[wi++] = wc;
        }
    }
    wstr[wi] = L'\0';
    
    current_locale = setlocale(LC_CTYPE, "SJIS");
    if (current_locale == NULL)
        return 0;
 
    ret = wcstombs(sjisBuffer, wstr, sjisBufLen);
 
    return ret;
}

void draw_utf8(int offset_x, int offset_y, char *buf_u)
{
    size_t sz;
    
    // assuming UTF-8 is NULL terminated
    sz = strlen(buf_u);
    int len = utf8tosjis(buf_u, sz, buf_s, sizeof(buf_s));

    for(int i = 0; i < len; i += 2) {
        font.read((buf_s[i] << 8) | buf_s[i+1]); 
        draw_kanji(i*8, 0);
    }
}


int main()
{
    lcd.cls();

    draw_utf8(0, 0, "進捗どうですか？");
    printf("進捗ありません。\n");

    while(1);
}
