// example to test the TFT Display
// Thanks to the GraphicsDisplay and TextDisplay classes from

#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

extern unsigned char p1[];  // the mbed logo

// the TFT is connected to SPI pin 5-7
//SPI_TFT TFT(p11, p12, p13, p14, p15,"TFT"); // mosi, miso, sclk, cs, reset
SPI_TFT TFT(CLCD_MOSI, CLCD_MISO, CLCD_SCLK, CLCD_SSEL , CLCD_RESET, "TFT"); // mosi, miso, sclk, cs, reset
Serial pc(USBTX, USBRX);

const uint16_t colorTable[18] = {
    Black,
    Navy,
    DarkGreen,
    DarkCyan,
    Maroon,
    Purple,
    Olive,
    LightGrey,
    DarkGrey,
    Blue,
    Green,
    Cyan,
    Red,
    Magenta,
    Yellow,
    White,
    Orange,
    GreenYellow
};

void screen2(void) // Graphics
{
    //Draw some graphics
    int i, x[2], y[2] ;

    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls() ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(90,0);
    TFT.printf("Graphics");

    x[0] = 25 ;
    x[1] = 224 ;
    y[0] = 20 ;
    y[1] = 219 ;
    for (i = 20 ; i < 220 ; i += 10) {
        TFT.line(i+5, y[0], i+5, y[1], Blue) ;
        TFT.line(x[0], i, x[1], i, Blue) ;
    }
    TFT.line(125, y[0], 125, y[1], Green) ;
    TFT.line(x[0], 120, x[1], 120, Green) ;
    TFT.rect(x[0],y[0], x[1], y[1], Green) ;
    TFT.locate(10, 20) ;
    TFT.printf("V") ;
    TFT.locate(0, 115) ;
    TFT.printf("0.0") ;
    TFT.locate(115, 225) ;
    TFT.printf("0.0") ;
    TFT.locate(215, 225) ;
    TFT.printf("T") ;

    double s;
    for (int i = x[0]; i < 225; i++) {
        s = 40 * sin((long double)i / 20);
        TFT.pixel(i, 120 + (int)s, White);
    }
#if 0
    TFT.fillrect(10, 240, 229, 309, White) ;
    TFT.rect(10, 240, 229, 309, Red) ;
    TFT.rect(11, 241, 228, 308, Red) ;

    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.locate(20, 250) ;
    TFT.printf("With QVGA resolution") ;
    TFT.locate(20, 270) ;
    TFT.printf("simple graphics drawing") ;
    TFT.locate(20, 290) ;
    TFT.printf("capability is provided") ;
#endif
}

int main()
{
    pc.baud(38400);
    pc.printf("Hello, mbed world.\n");
    pc.printf("System core lock : %d\n", SystemCoreClock);

    TFT.claim(stdout);      // send stdout to the TFT display
    //TFT.claim(stderr);      // send stderr to the TFT display

    while(1) {
        TFT.background(Black);    // set background to black
        TFT.foreground(White);    // set chars to white
        TFT.cls();                // clear the screen
        TFT.set_font((unsigned char*) Arial12x12);  // select the font

        // first show the 4 directions
        TFT.set_orientation(0);
        TFT.locate(0,0);
        printf("  Hello Mbed 0");
        TFT.set_orientation(1);
        TFT.locate(0,0);
        printf("  Hello Mbed 1");
        TFT.set_orientation(2);
        TFT.locate(0,0);
        printf("  Hello Mbed 2");
        TFT.set_orientation(3);
        TFT.locate(0,0);
        printf("  Hello Mbed 3");
        TFT.set_orientation(1);
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(50,100);
        TFT.printf("TFT orientation");

        wait(5);        // wait two seconds

        screen2();
        wait(5);

        // draw some graphics
        TFT.background(Black);    // set background to black
        TFT.foreground(White);    // set chars to white
        TFT.cls();
        TFT.set_orientation(1);
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(120,30);
        TFT.printf("Graphic");

        /*
        TFT.line(0,0,100,200,Green);
        TFT.rect(100,50,150,100,Red);
        TFT.fillrect(180,25,220,70,Blue);
        TFT.circle(80,150,33,White);
        */
        
        int c = 0;
        for(int i = 0; i < 32; i++) {
            TFT.fillrect(i*10, i*7, i*10 + 20, i*7 + 20, colorTable[c++]);
            TFT.rect(i*10, 240 - i*7,i*10 + 20, 240 - i*7 - 20, colorTable[c++]);
            TFT.circle(i*10, 120, 20, colorTable[c++]);
            if (c > 18)
                c = 0;
        }

        wait(5);        // wait two seconds

        // bigger text
        TFT.foreground(White);
        TFT.background(Blue);
        TFT.cls();
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(0,0);
        TFT.printf("Different Fonts :");

        TFT.set_font((unsigned char*) Neu42x35);
        TFT.locate(0,30);
        TFT.printf("Hello Mbed 1");
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(20,80);
        TFT.printf("Hello Mbed 2");
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.locate(35,120);
        TFT.printf("Hello Mbed 3");
        wait(5);

        // mbed logo
        TFT.set_orientation(1);
        TFT.background(Black);
        TFT.cls();
        TFT.Bitmap(90,90,172,55,p1);
        wait(5);
    }
}

