#include "mbed.h"

#define WAIT_TIME1 0.25
#define WAIT_TIME2 0.3
#define WAIT_TIME3 0.2
#define WAIT_TIME4 0.22

#define INTERVAL1 0.14
#define INTERVAL2 0.20
#define INTERVAL3 0.17
#define INTERVAL4 0.30

PwmOut Led1(LED1);
PwmOut Led2(LED2);
PwmOut Led3(LED3);
PwmOut Led4(LED4);

Ticker blinker1, blinker2, blinker3, blinker4;
float led1_val, led2_val, led3_val, led4_val;

void led1_event()
{
    Led1 = led1_val;

    if (led1_val == 0)
        led1_val = 1.0f;
    else
        led1_val -= INTERVAL1;

    if (led1_val < 0)
        led1_val = 0;
}

void led2_event()
{
    Led2 = led2_val;

    if (led2_val == 0)
        led2_val = 1.0f;
    else
        led2_val -= INTERVAL2;

    if (led2_val < 0)
        led2_val = 0;
}

void led3_event()
{
    Led3 = led3_val;

    if (led3_val == 0)
        led3_val = 1.0f;
    else
        led3_val -= INTERVAL3;

    if (led3_val < 0)
        led3_val = 0;
}

void led4_event()
{
    Led4 = led4_val;

    if (led4_val == 0)
        led4_val = 1.0f;
    else
        led4_val -= INTERVAL4;

    if (led4_val < 0)
        led4_val = 0;
}

int main() {

    led1_val = 1.0f;
    led2_val = 1.0f;
    led3_val = 1.0f;
    led4_val = 1.0f;
    
    blinker1.attach(&led1_event, WAIT_TIME1);
    blinker2.attach(&led2_event, WAIT_TIME2);
    blinker3.attach(&led3_event, WAIT_TIME3);
    blinker4.attach(&led4_event, WAIT_TIME4);

    while(1) {
    }
    
}
