/*
 * PCF8576 + GH08172 LCD test program
 */

#include "mbed.h"
#include "PCF8576.h"

PCF8576 lcd(D14, D15);
Ticker flipper;

void blink()
{
    static uint32_t cnt = 0;
    const uint32_t ptn[5] = {0, 1, 3, 7, 0xF};

    if (cnt > 4) {
        cnt = 0;
    }
    lcd.icon(ptn[cnt++]);
}

int main()
{
    char buf[6];    
    flipper.attach(&blink, 0.4);

    lcd.print("mbed");
    wait(5);

    int cnt = 0;
    while(1) {
        sprintf(buf, "%6d", cnt++);
        lcd.print(buf);
        wait(0.1);
    }
}
