/***************************************************************************
*  connections PCF8576 to GH08172:
*
*             a
*         ---------
*        | \  j  / |
*      f |  h | k  | b   *i
*        |   \|/   |
*         -g-- --m-
*        |   /|\   |
*      e |  q | n  | c   *i
*        | /  p  \ |
*         ---------  *l
*             d
*
**   definition of segments in 16 bits:
*   15  14  13  12 | 11  10  9   8  |  7   6   5   4  |  3   2   1   0
*   d   e   n   p  | c   m   l   i  |  f   g   h   q  |  a   b   j   k
*
***************************************************************************/
// segment bit masks
#define SEGK    0x0001u
#define SEGJ    0x0002u
#define SEGB    0x0004u
#define SEGA    0x0008u
#define SEGQ    0x0010u
#define SEGH    0x0020u
#define SEGG    0x0040u
#define SEGF    0x0080u
#define SEGI    0x0100u
#define SEGL    0x0200u
#define SEGM    0x0400u
#define SEGC    0x0800u
#define SEGP    0x1000u
#define SEGN    0x2000u
#define SEGE    0x4000u
#define SEGD    0x8000u

const uint16_t FontMatrix[] =
{
    0,                                                      // ' ' (space)
    SEGF | SEGE,                                            // ! (ugly)
    SEGF | SEGB,                                            // "
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF | SEGG |
    SEGH | SEGJ | SEGK | SEGM | SEGN | SEGP | SEGQ,         // #
    SEGA | SEGF | SEGG | SEGM | SEGC | SEGD | SEGJ | SEGP,  // $
    SEGF | SEGK | SEGQ | SEGC,                              // %
    SEGA | SEGK | SEGG | SEGE | SEGD | SEGN | SEGH,         // &
    SEGJ,                                                   // '
    SEGK | SEGN,                                            // ( (== '<')
    SEGH | SEGQ,                                            // ) (== '>')
    SEGH | SEGJ | SEGK | SEGG | SEGM | SEGQ | SEGP | SEGN,  // *
    SEGJ | SEGG | SEGM | SEGP,                              // +
    SEGP,                                                   // ,
    SEGG | SEGM,                                            // -
    SEGD,                                                   // . (== '_')
    SEGK | SEGQ,                                            // /
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF,                // 0
    SEGC | SEGB,                                            // 1
    SEGA | SEGB | SEGM | SEGG | SEGE | SEGD,                // 2
    SEGA | SEGB | SEGM | SEGG | SEGC | SEGD,                // 3
    SEGF | SEGG | SEGM | SEGB | SEGC,                       // 4
    SEGA | SEGF | SEGG | SEGM | SEGC | SEGD,                // 5
    SEGA | SEGF | SEGE | SEGD | SEGC | SEGM | SEGG,         // 6
    SEGA | SEGB | SEGC,                                     // 7
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF | SEGG | SEGM,  // 8
    SEGA | SEGF | SEGG | SEGM | SEGB | SEGC | SEGD,         // 9 (== 'g')
    SEGJ | SEGP,                                            // : (ugly)
    SEGJ | SEGQ,                                            // ; (ugly)
    SEGK | SEGN,                                            // < (== '(')
    SEGG | SEGM | SEGD,                                     // =
    SEGH | SEGQ,                                            // > (== ')')
    SEGA | SEGB | SEGM | SEGP,                              // ?
    SEGA | SEGB | SEGD | SEGE | SEGF | SEGJ | SEGM,         // @
    SEGE | SEGF | SEGA | SEGB | SEGC | SEGG | SEGM,         // A
    SEGA | SEGB | SEGC | SEGD | SEGJ | SEGP | SEGM,         // B
    SEGA | SEGF | SEGE | SEGD,                              // C
    SEGA | SEGB | SEGC | SEGD | SEGJ | SEGP,                // D
    SEGA | SEGF | SEGE | SEGD | SEGG | SEGM,                // E
    SEGA | SEGF | SEGE | SEGG | SEGM,                       // F
    SEGA | SEGF | SEGE | SEGD | SEGC | SEGM,                // G
    SEGF | SEGE | SEGG | SEGM | SEGB | SEGC,                // H
    SEGA | SEGJ | SEGP | SEGD,                              // I
    SEGB | SEGC | SEGD | SEGE,                              // J
    SEGF | SEGE | SEGG | SEGK | SEGN,                       // K
    SEGF | SEGE | SEGD,                                     // L
    SEGE | SEGF | SEGH | SEGK | SEGB | SEGC,                // M
    SEGE | SEGF | SEGH | SEGN | SEGC | SEGB,                // N
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF,                // O
    SEGE | SEGF | SEGA | SEGB | SEGG | SEGM,                // P
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF | SEGN,         // Q
    SEGE | SEGF | SEGA | SEGB | SEGG | SEGM | SEGN,         // R
    SEGA | SEGF | SEGG | SEGM | SEGC | SEGD,                // S
    SEGA | SEGJ | SEGP,                                     // T
    SEGF | SEGE | SEGD | SEGC | SEGB,                       // U
    SEGF | SEGE | SEGQ | SEGK,                              // V
    SEGF | SEGE | SEGQ | SEGN | SEGC | SEGB,                // W
    SEGH | SEGK | SEGQ | SEGN,                              // X
    SEGF | SEGG | SEGM | SEGB | SEGP,                       // Y
    SEGA | SEGK | SEGQ | SEGD,                              // Z
    SEGA | SEGF | SEGE | SEGD,                              // [
    SEGH | SEGN,                                            // backslash
    SEGA | SEGB | SEGC | SEGD,                              // ]
    SEGF | SEGH,                                            // ^
    SEGD,                                                   // _ (== '.')
    SEGH,                                                   // `
    SEGG | SEGM | SEGE | SEGD | SEGN,                       // a
    SEGF | SEGE | SEGD | SEGC | SEGG | SEGM,                // b
    SEGG | SEGM | SEGE | SEGD,                              // c
    SEGG | SEGM | SEGE | SEGD | SEGC | SEGB,                // d
    SEGQ | SEGG | SEGE | SEGD,                              // e
    SEGK | SEGG | SEGM | SEGP,                              // f
    SEGA | SEGF | SEGG | SEGM | SEGB | SEGC | SEGD,         // g (== '9')
    SEGF | SEGE | SEGG | SEGM | SEGC,                       // h
    SEGC,                                                   // i
    SEGB | SEGC | SEGN,                                     // j
    SEGJ | SEGP | SEGM | SEGN,                              // k
    SEGB | SEGC,                                            // l
    SEGE | SEGG | SEGM | SEGC | SEGP,                       // m
    SEGE | SEGG | SEGM | SEGC,                              // n
    SEGE | SEGG | SEGM | SEGC | SEGD,                       // o
    SEGF | SEGE | SEGH | SEGG,                              // p
    SEGB | SEGC | SEGM | SEGK,                              // q
    SEGE | SEGG | SEGM,                                     // r
    SEGM | SEGN | SEGD,                                     // s
    SEGJ | SEGP | SEGG | SEGM,                              // t
    SEGE | SEGD | SEGC,                                     // u
    SEGE | SEGQ,                                            // v
    SEGE | SEGQ | SEGN | SEGC,                              // w
    SEGH | SEGK | SEGN | SEGQ,                              // x
    SEGH | SEGK | SEGP,                                     // y
    SEGG | SEGQ | SEGD,                                     // z
    SEGK | SEGG | SEGN,                                     // {
    SEGJ | SEGP,                                            // |
    SEGH | SEGM | SEGQ,                                     // }
    SEGF | SEGH | SEGJ,                                     // ~
    SEGA | SEGB | SEGC | SEGD | SEGE | SEGF | SEGG |
    SEGH | SEGJ | SEGK | SEGM | SEGN | SEGP | SEGQ          // DEL (== '#')
};
