/* Copyright (c) 2016 ARM Ltd., MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*/
#include "PCF8576.h"

PCF8576::PCF8576(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr)
{
    initialize();
}
 
PCF8576::PCF8576(I2C &i2c_obj, int addr) : m_i2c(i2c_obj), m_addr(addr)
{
    initialize();
}
 
PCF8576::~PCF8576()
{
}

void PCF8576::initialize()
{
    m_i2c.frequency(200000);

    for(uint32_t i = 0; i < 14; i++) {
        m_lcd_buf[i] = 0;
    }
    
    m_C5_mask = m_C6_mask = 0;

    m_lcd_buf[0]      =  PCF8576_CMD_MODE_SET
                       | (0x0 << 0)          // 1:4 multiplex
                       | (0   << 2)          // LCD 1/3 bias
                       | (1   << 3)          // enable display
                       | (1   << 7);         // another command to follow

    m_lcd_buf[1]      =  PCF8576_CMD_BINK
                       | (0x0 << 0)          // blinking off
                       | (0   << 2)          // blink mode normal
                       | (0   << 7);         // last command

    m_i2c.write(PCF8576_DEFAULT_SLAVE_ADDRESS, m_lcd_buf, 14);

}

void PCF8576::icon(uint32_t count)
{
    if (count & 0x08) {
        m_C5_mask     |= 0x01;
        m_lcd_buf[11] |= 0x01;
    } else {
        m_C5_mask     &= ~0x01;
        m_lcd_buf[11] &= ~0x01;
    }

    if (count & 0x04) {
        m_C5_mask     |= 0x02;
        m_lcd_buf[11] |= 0x02;
    } else {
        m_C5_mask     &= ~0x02;
        m_lcd_buf[11] &= ~0x02;
    }

    if (count & 0x02) {
        m_C6_mask     |= 0x01;
        m_lcd_buf[13] |= 0x01;
    } else {
        m_C6_mask     &= ~0x01;
        m_lcd_buf[13] &= ~0x01;
    }

    if (count & 0x01) {
        m_C6_mask     |= 0x02;
        m_lcd_buf[13] |= 0x02;
    } else {
        m_C6_mask     &= ~0x02;
        m_lcd_buf[13] &= ~0x02;
    }
    m_i2c.write(PCF8576_DEFAULT_SLAVE_ADDRESS, m_lcd_buf, 14);

}


void PCF8576::print(char *str)
{
    uint32_t len = strlen(str);
    if (len == 0)
        return;
    if (len > 6)
        len = 6;

    m_lcd_buf[0] = PCF8576_CMD_DEVICE_SEL | (1 << 7);
    m_lcd_buf[1] = PCF8576_CMD_LOAD_DATA;

    for(uint32_t i = 0; i < len; i++) {
        m_lcd_buf[(i*2) + 2] = (char)(FontMatrix[(*str - ' ')] & 0xFF);
        m_lcd_buf[(i*2) + 3] = (char)(FontMatrix[(*str - ' ')] >> 8);
        str++;
    }

    m_lcd_buf[11] |= m_C5_mask;
    m_lcd_buf[13] |= m_C6_mask;

    m_i2c.write(PCF8576_DEFAULT_SLAVE_ADDRESS, m_lcd_buf, 2 + (len*2));
}
