#include "mbed.h"
#include "LM75B.h"
#include "ST7567.h"
#include "PCAL9555.h"

ST7567 lcd(D11, D13, D12, D9, D10); // mosi, sclk, reset, A0, nCS
DigitalOut myled(LED1);
LM75B sensor(D14,D15, LM75B::ADDRESS_4);
AnalogIn pot(A3);
PCAL9555    gpio_exp(SDA, SCL);
GpioBusOut  leds(gpio_exp, X1_4, X1_5, X1_6, X1_7);

static const int led_pattern[] = {
    0xF,
    ~(1 << 0),
    ~(1 << 1),
    ~(1 << 2),
    ~(1 << 3),
    0xF,
    ~(1 << 3),
    ~(1 << 2),
    ~(1 << 1),
    ~(1 << 0),
};


int main()
{
    int count = 0;
    
    lcd.set_contrast(0x3f);
    lcd.cls();
    
    lcd.locate(0, 1);
    lcd.printf("LPC General Purpose Shield");
    lcd.locate(0, 2 + 8);
    lcd.printf("[OM13082] test program");

    while(1) {

        for (int i=0; i<10; i++) {
            int val = (int)(pot*10);
            lcd.fillrect(i*8, 53, (i*8)+6, 63, val/(i+1));
            lcd.rect(i*8, 53, (i*8)+6, 63, 1);
        }

        leds.write(led_pattern[count++]);
        if (count > 10)
            count = 0;

        lcd.locate(0, 2 + 8*3);
        lcd.printf("Temperature = %.1f\n", sensor.temp());
        lcd.locate(0, 2 + 8*4);
        lcd.printf("Potentiometer = %.2f\n", (float)pot);
        myled = 1;
        wait(0.2);
        
        myled = 0;
        wait(0.2);
    }
}
