#include "mbed.h"
#include "ST7567.h"

ST7567 lcd(D11, D13, D12, D9, D10); // mosi, sclk, reset, A0, nCS

int main()
{
    int count=0;
    lcd.set_contrast(0x3f);
    lcd.cls();
    
    lcd.locate(0, 1);
    lcd.printf("LPC General Purpose Shield");
    lcd.locate(0, 2 + 8);
    lcd.printf("[OM13082] test program");
    
    lcd.rect(80, 20, 80+40, 20+40, 1);
    lcd.circle(20, 40, 20, 1);

    while(true) {   // this is the third thread
        lcd.locate(0, 3 + 24);
        lcd.printf("Counting : %d",count);
        count++;
        wait(1.0);
    }
}
