#include "mbed.h"
#include "PCAL9555.h"

PCAL9555    gpio_exp(SDA, SCL);
GpioBusIn   joystick(gpio_exp, X0_0, X0_1, X0_2, X0_3, X0_4);
Serial      pc(USBTX, USBRX);

enum key_num {
    Key_Up     = (1 << X0_4),
    Key_Down   = (1 << X0_0),
    Key_Right  = (1 << X0_3),
    Key_Left   = (1 << X0_2),
    Key_Center = (1 << X0_1),
};

int main()
{
    while(1) {
        int keys = joystick.read();
        if ((keys & Key_Up) == 0)
            pc.printf("Up\n");
        if ((keys & Key_Down) == 0)
            pc.printf("Down\n");
        if ((keys & Key_Right) == 0)
            pc.printf("Right\n");
        if ((keys & Key_Left) == 0)
            pc.printf("Left\n");
        if ((keys & Key_Center) == 0)
            pc.printf("Center\n");
        wait(0.3);
    }
}
