#include "mbed.h"
#include "MiCS6814_GasSensor.h"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
MiCS6814_GasSensor sensor(p28, p27);
#else
MiCS6814_GasSensor sensor(I2C_SDA, I2C_SCL);
#endif

int main()
{
    pc.printf("test start\n");

    while(1) {
        pc.printf("NH3: %.2f ppm, CO: %.2f ppm, NO2: %.2f ppm, C3H8: %.2f ppm \r\n", sensor.getGas(NH3), sensor.getGas(CO), sensor.getGas(NO2), sensor.getGas(C3H8));
        pc.printf("C4H10: %.2f ppm, CH4: %.2f ppm, H2: %.2f ppm, C2H5OH: %.2f ppm \r\n", sensor.getGas(C4H10), sensor.getGas(CH4), sensor.getGas(H2), sensor.getGas(C2H5OH));
        pc.printf("\r\n");
        wait(1);
    }
}
