#include "mbed.h"
#include "MB85RSxx_SPI.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
MB85RSxx_SPI fram(p5, p6, p7, p8); // mosi, miso, sclk, cs
#elif defined(TARGET_LPC1114)
MB85RSxx_SPI fram(dp2, dp1, dp6, dp9); // mosi, miso, sclk, cs
#else // Arduino R3 Shield form factor
MB85RSxx_SPI fram(D11, D12, D13, D10); // mosi, miso, sclk, cs
#endif

int main()
{
    uint8_t buf[16];
    uint32_t address;

    pc.baud(115200);
    pc.printf("\nFujitsu MB85RSxxx FRAM test program\n\n");

    // Read device ID and detect memory density for addressing
    fram.read_device_id(buf);
    pc.printf("read device ID = 0x%x 0x%x 0x%x 0x%x\n", buf[0], buf[1], buf[2], buf[3]);

    fram.write_enable();
    pc.printf("read status (WREN) = 0x%x\n", fram.read_status());

    fram.write_disable();
    pc.printf("read status (WRDI) = 0x%x\n", fram.read_status());

    // Write 0 data
    fram.write_enable();
    fram.fill(0, 0, 256);

    // Prepare write data
    for (int i = 0; i < 16; i++) {
        buf[i] = i;
    }

    // Write data with write enable
    fram.write_enable();
    fram.write(0x00, buf, 16);

    // Attempt to write data (not written)
    fram.write(0x10, buf, 16);

    // Write data with write enable
    fram.write_enable();
    fram.write(0x20, buf, 16);

    // Read data
    for (address = 0; address < 0x80; address += 16) {
        fram.read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);
        }
        pc.printf("\n");
    }

    // Write number from 0 to 255
    pc.printf("\n");
    for (address = 0; address < 0x100; address++) {
        fram.write_enable();
        fram.write(address, (uint8_t)address);
    }
    // Read data
    for (address = 0; address < 0x100; address += 16) {
        fram.read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);
        }
        pc.printf("\n");
    }

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

