#include "mbed.h"
#include "MB85RCxx_I2C.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
MB85RCxx_I2C fram(p9, p10);
#elif defined(TARGET_LPC1114)
MB85RCxx_I2C fram(dp5, dp27);
#else
MB85RCxx_I2C fram(D14, D15);
#endif

int main() {
    char buf[16];
    uint32_t address;

    pc.baud(115200);
    pc.printf("\nFujitsu MB85RCxxx FRAM test program\n\n");
    
    fram.read_device_id(buf);
        
    pc.printf("read device ID = 0x%x 0x%x 0x%x\n\n", buf[0], buf[1], buf[2]);

    fram.fill(0, 0, 256);

    for (int i = 0; i < 16; i++) {
        buf[i] = i;
    }
    fram.write(0, buf, 16);

    for (address = 0; address < 0x80; address += 16) {
        fram.read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);    
        }
        pc.printf("\n");
    }

    pc.printf("\n");
    for (address = 0; address < 0x100; address++) {
        fram.write(address, (uint8_t)address);
    }
    for (address = 0; address < 0x100; address += 16) {
        fram.read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);    
        }
        pc.printf("\n");
    }
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
