#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
I2C _i2c(p9, p10);
#elif defined(TARGET_LPC1114)
I2C _i2c(dp5, dp27);
#else
I2C _i2c(D14, D15);
#endif

#define MB85_DENSITY_64K    0x3
#define MB85_DENSITY_256K   0x5
#define MB85_DENSITY_512K   0x6
#define MB85_DENSITY_1M     0x7
#define MB85_DENSITY_2M     0x8
#define MB85RC_I2C_ADDRESS  0xA0
#define I2C_WRITE           0
#define I2C_READ            1

int read_device_id(char* device_id)
{
    char buf;

    buf = MB85RC_I2C_ADDRESS;
    _i2c.write(0xF8, &buf, 1, true);
    _i2c.read(0xF9, device_id, 3);
    
    return 0;
}

int read(uint32_t address, char *buf, uint32_t len)
{
    char byte_address[2];
    char i2c_adrs = (MB85RC_I2C_ADDRESS | ((address >> 15) & 0x02));
    
    byte_address[0] = ((address >> 8) & 0xFF);
    byte_address[1] = ((address >> 0) & 0xFF);
    _i2c.write(i2c_adrs, byte_address, 2, true);
    _i2c.read(i2c_adrs, buf, len);
    
    return 0;
}

int write(uint32_t address, char *buf, uint32_t len)
{
    char byte_address[2];
    char i2c_adrs = (MB85RC_I2C_ADDRESS | ((address >> 15) & 0x02));
    
    byte_address[0] = ((address >> 8) & 0xFF);
    byte_address[1] = ((address >> 0) & 0xFF);
    _i2c.write(i2c_adrs, byte_address, 2, true);
    for (uint32_t i = 0; i < len; i++) {
        _i2c.write(*buf++);
    }

    return 0;
}

int write(uint32_t address, char buf)
{
    char byte_address[2];
    char i2c_adrs = (MB85RC_I2C_ADDRESS | ((address >> 15) & 0x02));
    
    byte_address[0] = ((address >> 8) & 0xFF);
    byte_address[1] = ((address >> 0) & 0xFF);
    _i2c.write(i2c_adrs, byte_address, 2, true);
    _i2c.write(buf);

    return 0;
}

int fill(uint32_t address, uint8_t data, uint32_t len)
{
    char byte_address[2];
    char i2c_adrs = (MB85RC_I2C_ADDRESS | ((address >> 15) & 0x02));
    
    byte_address[0] = ((address >> 8) & 0xFF);
    byte_address[1] = ((address >> 0) & 0xFF);
    _i2c.write(i2c_adrs, byte_address, 2, true);
    for (uint32_t i = 0; i < len; i++) {
        _i2c.write(data);
    }
    return 0;
}

int main() {
    char buf[16];
    uint32_t address;

    pc.baud(115200);
    pc.printf("\nFujitsu MB85RCxxx FRAM test program\n\n");
    
    _i2c.frequency(400000);
    read_device_id(buf);
        
    pc.printf("read device ID = 0x%x 0x%x 0x%x\n\n", buf[0], buf[1], buf[2]);

    fill(0, 0, 256);

    for (int i = 0; i < 16; i++) {
        buf[i] = i;
    }
    write(0, buf, 16);

    for (address = 0; address < 0x80; address += 16) {
        read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);    
        }
        pc.printf("\n");
    }

    pc.printf("\n");
    for (address = 0; address < 0x100; address++) {
        write(address, (uint8_t)address);
    }
    for (address = 0; address < 0x100; address += 16) {
        read(address, buf, 16);
        pc.printf("%08X : ", address);
        for (int i = 0; i < 16; i++) {
            pc.printf("%02X ", buf[i]);    
        }
        pc.printf("\n");
    }
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
