#include "mbed.h"

#if defined(TARGET_LPC812)
I2C gpio_exp(P0_10, P0_11);
#elif defined(TARGET_LPC810)
I2C gpio_exp(dp2, dp3);
#else
I2C gpio_exp(SDA, SCL);
#endif

Ticker tick;
static int _seg;
static int _chrs[4];

const char dispTabl[] = {
    0x7E, // 0
    0x30, // 1
    0x6D, // 2
    0x79, // 3
    0x33, // 4
    0x5B, // 5
    0x5F, // 6
    0x70, // 7
    0x7F, // 8
    0x7B, // 9
};

void update()
{
    int port_0;
    int _data;

    _data = (dispTabl[_chrs[_seg]]);

    switch(_seg) {
        case 0:
            port_0 = 0x70;
            _seg = 1;
            break;
        case 1:
            port_0 = 0xb0;
            _seg = 2;
            break;
        case 2:
            port_0 = 0xd0;
            _seg = 3;
            break;
        case 3:
            port_0 = 0xe0;
            _seg = 0;
            break;
    }

    char buf[3];
    buf[0] = 2;      // OUTPUT
    buf[1] = port_0; // Port 0
    buf[2] = _data;  // Port 1
    gpio_exp.write(0x40, buf, 3);
}

void write_number(int num)
{
    num %= 10000;
    _chrs[0] = (num/1000);
    _chrs[1] = ((num/100)%10);
    _chrs[2] = (((num/10)%100)%10);
    _chrs[3] = (((num%1000)%100)%10);
}

int main()
{
    _seg = 0;

    char buf[3];
    buf[0] = 0x06; // CONFIG
    buf[1] = 0;    // output
    buf[2] = 0;    // output
    gpio_exp.write(0x40, buf, 3);
    wait(0.5);

    tick.attach(&update, 0.01); // 10 msec

    int cnt = 0;
    while(1) {
        write_number(cnt++);
        wait(0.1); // 100ms
    }
}

void error(const char* format, ...) {
}
