/*
 * PackageLicenseDeclared: Apache-2.0
 * Copyright (c) Toyomasa Watarai
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"
#include "BME280.h"

#define IFTTT_SECRET_KEY   "YOUR_SECRET_KEY_OF_THE_MAKER_CHANNEL" // https://ifttt.com/maker
#define WIFI_SSID          "SSID"
#define WIFI_PASSWORD      "PASSWORD"

ESP8266Interface wifi(dp9, dp8, dp7, WIFI_SSID, WIFI_PASSWORD); // TX, RX, Reset, SSID, Password
Serial pc(USBTX, USBRX);
BME280 sensor(I2C_SDA, I2C_SCL);
InterruptIn btn1(dp16);
InterruptIn btn2(dp15);

static int has_event = 0;

void btn1_pressed()
{
    has_event = 1;
}

void btn2_pressed()
{
    has_event = 2;
}

int main()
{
    btn1.mode(PullUp);
    btn2.mode(PullUp);
    btn1.fall(&btn1_pressed);
    btn2.fall(&btn2_pressed);

    wifi.init();
    wifi.connect(); //Use DHCP
    pc.printf("\nIP Address is %s\n", wifi.getIPAddress());
    TCPSocketConnection socket;

    while(1) {
        char v1[8], v2[8], v3[8];
        float f1, f2, f3;
        f1 = sensor.getTemperature();
        f2 = sensor.getHumidity();
        f3 = sensor.getPressure();
        sprintf(v1, "%2.2f", f1);
        sprintf(v2, "%2.2f", f2);
        sprintf(v3, "%4.2f", f3);
        pc.printf("%2.2f degC, %2.2f %%, %04.2f hPa, \n", f1, f2, f3);

        if (has_event == 1) {
            IFTTT ifttt("BME280_iOS", IFTTT_SECRET_KEY, &socket);
            ifttt.addIngredients(v1, v2, v3);
            ifttt.trigger(IFTTT_POST);
            has_event = 0;
        }
        if (has_event == 2) {
            IFTTT ifttt("BME280_Android", IFTTT_SECRET_KEY, &socket);
            ifttt.addIngredients(v1, v2, v3);
            ifttt.trigger(IFTTT_POST);
            has_event = 0;
        }
        wait(1);
    }
}
