
#if !defined(MQTTWIFI_H)
#define MQTTWIFI_H

#include "MQTTmbed.h"
#include "SNIC_WifiInterface.h"
#include "MQTTSocket.h"
#include "WiFi_Config.h"

class MQTTWifi : public MQTTSocket
{
public:
    MQTTWifi()
    {
        wifi.create(WIFI_TX, WIFI_RX, WIFI_CTS, WIFI_RTS, WIFI_RESET);
        wifi.init();
        wait(0.5);
        wifi.disconnect();
        wait(0.3);
        wifi.connect( DEMO_AP_SSID
                    , strlen(DEMO_AP_SSID)
                    , DEMO_AP_SECURITY_TYPE
                    , DEMO_AP_SECUTIRY_KEY
                    , strlen(DEMO_AP_SECUTIRY_KEY) );
        wait(0.5);
        wifi.setIPConfig(true);
    }
    
    C_SNIC_WifiInterface& getEth()
    {
        return wifi;
    }
    
    void reconnect()
    {
        wifi.init();
        wait(0.5);
        wifi.disconnect();
        wait(0.3);
        wifi.connect( DEMO_AP_SSID
                    , strlen(DEMO_AP_SSID)
                    , DEMO_AP_SECURITY_TYPE
                    , DEMO_AP_SECUTIRY_KEY
                    , strlen(DEMO_AP_SECUTIRY_KEY) );
        wait(0.5);
        wifi.setIPConfig(true);
    }

private:
    C_SNIC_WifiInterface wifi;
};

#endif
