/* Mpression Uzuki sensor shield test program
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *  Mpression Uzuki sensor shield test program
 *
 *  @author  Toyomasa Watarai
 *  @version 1.0
 *  @date    3-March-2016
 *
 *  http://www.m-pression.com/ja/solutions/boards/uzuki-shield?p_auth=P2omuceK&p_p_id=82&p_p_lifecycle=1&p_p_state=normal&p_p_mode=view&_82_struts_action=%2Flanguage%2Fview&languageId=en_US
 *
 *  ADXL345 : Accelerometer
 *  Si7013  : Temperature & Humidity Sensor
 *  Si1145  : Proximity, Luminescence & UV Level Sensor
 *
 */

#include "mbed.h"
#include "ADXL345_I2C.h"
#include "Si7020.h"
#include "Si114x.h"

Serial pc(USBTX, USBRX);
ADXL345_I2C adxl345(A4, A5);
Si7020 si7013(A4, A5);
Si114x si1145(A4, A5);

int main() {
    int buf[3];
    float humid, temp;
    float uv;

    adxl345.setPowerControl(0x00);
    adxl345.setDataFormatControl(0x0B);
    adxl345.setDataRate(ADXL345_3200HZ);
    adxl345.setPowerControl(0x08);
    
    while(si1145.verifyConnection() != 1);
    
    while(1) {
        adxl345.getOutput(buf);
        pc.printf("ax: %-5d, ay: %-5d, az: %-5d\n", (int16_t)buf[0], (int16_t)buf[1], (int16_t)buf[2]);

        si7013.getHumidity(&humid);
        si7013.getTemperature(&temp);
        pc.printf("Humidity: %6.2f%%, Temperature: %6.2fC\n", humid, temp);
        
        uv = (float)si1145.getUVIndex()/100;
        pc.printf("Vis: %d, IR: %d, UV: %6.3f\n", si1145.getVisibleLight(), si1145.getIRLight(), uv);
        
        pc.printf("\n");
        wait(1);
    }
}
