/* Cypress FM25W256 F-RAM component library test program
 *
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *  *
 *  @author  Toyomasa Watarai
 *  @version 1.0
 *  @date    5-March-2016
 *
 *  http://www.cypress.com/products/nonvolatile-ram
 *  http://www.cypress.com/documentation/datasheets/fm25w256-256-kbit-32-k-8-serial-spi-f-ram?source=search&keywords=FM25W256&cat=technical_documents
 *
 */

#include "mbed.h"
#include "FM25W256.h"

Serial pc(USBTX, USBRX);
#if defined(TARGET_LPC1114)
FM25W256 f_ram(dp2, dp1, dp6, dp18);
#elif defined(TARGET_LPC1768)
FM25W256 f_ram(p5, p6, p7, p8);
#endif

void read_test()
{
    uint16_t adrs = 0;
    for(int i=0; i<16; i++) {
        pc.printf("0x%04X : ", i * 16);
        for(int j=0; j<16; j++) {
            pc.printf("%02X ", f_ram.read(adrs++));
        }
        pc.printf("\n");
    }
}
    
void write_test()
{
    uint8_t buf[16];
    for(int i=0; i<16; i++) {
        buf[i] = (15 - i);
    }
    f_ram.write(0, buf, 16);
}

void write_protect_test()
{
    f_ram.set_write_protect(FM25W256::BANK_ALL);

    pc.printf("[write data]\n");
    pc.printf("0x0000 : ");
    uint8_t buf[16];
    for(int i=0; i<16; i++) {
        buf[i] = i;
        pc.printf("%02X ", buf[i]);
    }
    pc.printf("\n");
    f_ram.write(0, buf, 16);

    pc.printf("[read data]\n");
    read_test();

    f_ram.clear_write_protect();
}

int main()
{
    pc.printf("\nFM25W256 test program - write test? (y/n) ");
    if (pc.getc() == 'y') {
        write_test();
    }

    pc.printf("\nFM25W256 test program - read test? (y/n) ");
    if (pc.getc() == 'y') {
        pc.printf("\n");
        read_test();
    }
    
    pc.printf("\nFM25W256 test program - write protect test? (y/n) ");
    if (pc.getc() == 'y') {
        pc.printf("\n");
        write_protect_test();
    }

    while(1) {
    }
}
