#include "mbed.h"
#include "FM25W256.h"

Serial pc(USBTX, USBRX);
FM25W256 f_ram(dp2, dp1, dp6, dp18);

void read_test()
{
    uint16_t adrs = 0;
    for(int i=0; i<16; i++) {
        pc.printf("0x%04X : ", i * 16);
        for(int j=0; j<16; j++) {
            pc.printf("%02X ", f_ram.read(adrs++));
        }
        pc.printf("\n");
    }
}
    
void write_test()
{
    uint8_t buf[16];
    for(int i=0; i<16; i++) {
        buf[i] = (15 - i);
    }
    f_ram.write(0, buf, 16);
}

int main()
{
    pc.printf("\nFM25W256 test program - write test? (y/n) ");
    if (pc.getc() == 'y') {
        write_test();
    }

    pc.printf("\nFM25W256 test program - read test? (y/n) ");
    if (pc.getc() == 'y') {
        pc.printf("\n");
        read_test();
    }

    while(1) {
    }
}
