#include "mbed.h"
#include "C12832_lcd.h"

unsigned char matrixdata[32];
C12832_LCD lcd;

void read_font(unsigned short code) {
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    DigitalOut cs(p10);
    unsigned char  c1, c2, MSB,LSB;
    uint32_t Address, seq;

    // SJIS to kuten code conversion
    c1 = (code>>8);
    c2 = (code & 0xFF);
    seq = (c1<=159 ? c1-129 : c1-193)*188 + (c2<=126 ? c2-64 : c2-65);
    MSB = seq / 94 + 1;
    LSB = seq % 94 + 1;
    Address = 0;
        
    if(     MSB >=  1 && MSB <= 15 && LSB >= 1 && LSB <= 94)
        Address =( (MSB -  1) * 94 + (LSB - 1))*32;
    else if(MSB >= 16 && MSB <= 47 && LSB >= 1 && LSB <= 94)
        Address =( (MSB - 16) * 94 + (LSB - 1))*32 + 0x0AA40L;
    else if(MSB >= 48 && MSB <= 84 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 48) * 94 + (LSB - 1))*32 + 0x21CDFL;
    else if(MSB == 85 &&                LSB >= 1 && LSB <= 94)
        Address = ((MSB - 85) * 94 + (LSB - 1))*32 + 0x3C4A0L;
    else if(MSB >= 88 && MSB <= 89 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 88) * 94 + (LSB - 1))*32 + 0x3D060L;
    
    // Deselect the device
    cs = 1;

    // Setup the spi for 8 bit data, high steady state clock
    spi.format(8,3);
    spi.frequency(1000000); 
    
    // Select the device by seting chip select low
    cs = 0;
    spi.write(0x03);    // Read data byte
    spi.write(Address>>16 & 0xff);
    spi.write(Address>>8 & 0xff);
    spi.write(Address & 0xff);
    
    // Send a dummy byte to receive the contents of the WHOAMI register
    for(int i=0; i<32; i++)
    {
      matrixdata[i]=spi.write(0x00);
    }

    // Deselect the device
    cs = 1;
}


void draw_kanji(int offset_x, int offset_y)
{
    int color;
    for(int x=0; x<32; x++)
    {
        for(int y=0; y<8; y++)
        {
        if (matrixdata[x] & (1<<y))
            color = 1;
        else
            color = 0;
        lcd.pixel(x%16 + offset_x, y+(8*(x>>4)) + offset_y, color);
        }
    }
    lcd.copy_to_lcd();
}

int main()
{
    unsigned short kbuf[16] = {0x93fa, 0x967b, 0x8cea, 0x955c, 0x8ea6};

    lcd.cls();

    for(int i=0; i<5; i++) {
        read_font(kbuf[i]); 
        draw_kanji(16*i, 0);
    }
    
}
